/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.rei;

import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class MendermanReiClientPlugin
implements REIClientPlugin {
    private static List<Display> cachedAnvilDisplays = null;

    public void registerDisplays(DisplayRegistry registry) {
        cachedAnvilDisplays = null;
        registry.registerVisibilityPredicate((category, display) -> {
            if (category.getCategoryIdentifier().equals((Object)BuiltinPlugin.ANVIL) && display instanceof DefaultAnvilDisplay) {
                class_1799 stack;
                Object patt0$temp;
                DefaultAnvilDisplay anvilDisplay = (DefaultAnvilDisplay)display;
                if (anvilDisplay.getDisplayLocation().isPresent()) {
                    return EventResult.pass();
                }
                EntryStack inputEntryStack = (EntryStack)((EntryIngredient)anvilDisplay.getInputEntries().getFirst()).getFirst();
                EntryStack otherInputEntryStack = (EntryStack)((EntryIngredient)anvilDisplay.getInputEntries().getLast()).getFirst();
                EntryStack outputEntryStack = (EntryStack)((EntryIngredient)anvilDisplay.getOutputEntries().getFirst()).getFirst();
                if (inputEntryStack.getType() != VanillaEntryTypes.ITEM || outputEntryStack.getType() != VanillaEntryTypes.ITEM) {
                    return EventResult.pass();
                }
                class_1799 inputStack = (class_1799)inputEntryStack.castValue();
                class_1799 outputStack = (class_1799)outputEntryStack.castValue();
                class_1799 inputWithoutDamage = inputStack.method_7972();
                class_1799 outputWithoutDamage = outputStack.method_7972();
                inputWithoutDamage.method_7974(0);
                outputWithoutDamage.method_7974(0);
                if (class_1799.method_31577((class_1799)inputWithoutDamage, (class_1799)outputWithoutDamage) && MendermanRecipeViewerHelper.getRepairStacks().stream().anyMatch(entry -> entry.repairable().method_31574(inputStack.method_7909())) || inputStack.method_57826(class_9334.field_53696) && (!((patt0$temp = otherInputEntryStack.getValue()) instanceof class_1799) || !(stack = (class_1799)patt0$temp).method_31574(class_1802.field_8598))) {
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
        MendermanReiClientPlugin.createMaterialRepairRecipes(registry);
    }

    private static void createMaterialRepairRecipes(DisplayRegistry registry) {
        List<MendermanRecipeViewerHelper.RepairEntry> repairEntryMap = MendermanRecipeViewerHelper.getRepairStacks();
        Consumer<Display> consumer = arg_0 -> ((DisplayRegistry)registry).add(arg_0);
        for (MendermanRecipeViewerHelper.RepairEntry entry : repairEntryMap) {
            MendermanReiClientPlugin.addRepairEntryAnvilRecipes(consumer, entry);
        }
    }

    private static void addRepairEntryAnvilRecipes(Consumer<Display> addRecipeConsumer, MendermanRecipeViewerHelper.RepairEntry entry) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.repairable().method_7909());
        if (!entry.materials().isEmpty()) {
            for (class_1799 material : entry.materials()) {
                class_2960 materialId = class_7923.field_41178.method_10221((Object)material.method_7909());
                int maxRepairCount = MendermanRepairHelper.getMaximumItemRepairMaterialCount(entry.repairable(), material);
                for (int i = 1; i <= maxRepairCount; ++i) {
                    class_1799 repairable = entry.repairable().method_7972();
                    repairable.method_7974(i == 1 ? repairable.method_7936() : repairable.method_7936() - MendermanRepairHelper.getRepairRequirementsRepairAmount(repairable, material.method_46651(i - 1)).orElse(0));
                    class_1799 countedMaterial = material.method_46651(i);
                    class_1799 repaired = entry.repairable().method_7972();
                    repaired.method_7974(repairable.method_7936() - MendermanRepairHelper.getRepairRequirementsRepairAmount(repairable, countedMaterial).orElse(repairable.method_7936()));
                    addRecipeConsumer.accept((Display)new DefaultAnvilDisplay(List.of(EntryIngredients.of((class_1799)repairable), EntryIngredients.of((class_1799)countedMaterial)), List.of(EntryIngredients.of((class_1799)repaired)), Optional.of(class_2960.method_60655((String)"menderman", (String)("anvil/repair/" + itemId.method_12836() + "/" + itemId.method_12832() + "/material/" + materialId.method_12836() + "/" + materialId.method_12832() + "/cost/" + i))), OptionalInt.of(i)));
                }
            }
        }
    }

    public static Map<CategoryIdentifier<?>, List<Display>> sortDisplayList(Map<CategoryIdentifier<?>, List<Display>> unmodified) {
        HashMap displays = new HashMap(unmodified);
        if (cachedAnvilDisplays == null) {
            cachedAnvilDisplays = MendermanReiClientPlugin.remapAnvilDisplays(unmodified.getOrDefault(BuiltinClientPlugin.ANVIL, Collections.emptyList()));
        }
        displays.put(BuiltinClientPlugin.ANVIL, cachedAnvilDisplays);
        return displays;
    }

    private static List<Display> remapAnvilDisplays(List<Display> list) {
        ArrayList<Display> newList = new ArrayList<Display>(list);
        for (int i = 0; i < list.size(); ++i) {
            class_1799 otherStack;
            class_1799 stack;
            DefaultAnvilDisplay defaultAnvilDisplay;
            Object object;
            Display display = list.get(i);
            if (display.getDisplayLocation().isEmpty() || !(display instanceof DefaultAnvilDisplay) || !((object = ((EntryStack)((EntryIngredient)(defaultAnvilDisplay = (DefaultAnvilDisplay)display).getInputEntries().getFirst()).getFirst()).getValue()) instanceof class_1799) || !(stack = (class_1799)object).method_57826(class_9334.field_53696) || !((object = ((EntryStack)((EntryIngredient)defaultAnvilDisplay.getInputEntries().getLast()).getFirst()).getValue()) instanceof class_1799) || (otherStack = (class_1799)object).method_31574(class_1802.field_8598)) continue;
            OptionalInt indexOfPrecursor = list.stream().filter(existingDisplay -> {
                class_1799 secondStack;
                Object patt1$temp;
                class_1799 firstStack;
                Object patt0$temp;
                return existingDisplay.getDisplayLocation().isEmpty() && (patt0$temp = ((EntryStack)((EntryIngredient)existingDisplay.getInputEntries().getFirst()).getFirst()).getValue()) instanceof class_1799 && class_1799.method_7984((class_1799)stack, (class_1799)(firstStack = (class_1799)patt0$temp)) && (patt1$temp = ((EntryStack)((EntryIngredient)existingDisplay.getInputEntries().getLast()).getFirst()).getValue()) instanceof class_1799 && !(secondStack = (class_1799)patt1$temp).method_31574(class_1802.field_8598);
            }).mapToInt(newList::indexOf).max();
            indexOfPrecursor.ifPresentOrElse(value -> {
                newList.remove(display);
                newList.add(value, display);
            }, () -> {
                OptionalInt indexBeforeEnchantments = list.stream().filter(existingDisplay -> {
                    class_1799 secondStack;
                    Object patt0$temp;
                    return existingDisplay.getDisplayLocation().isEmpty() && (patt0$temp = ((EntryStack)((EntryIngredient)existingDisplay.getInputEntries().getLast()).getFirst()).getValue()) instanceof class_1799 && (secondStack = (class_1799)patt0$temp).method_31574(class_1802.field_8598);
                }).mapToInt(newList::indexOf).min();
                indexBeforeEnchantments.ifPresent(value -> {
                    newList.remove(display);
                    newList.add(value, display);
                });
            });
        }
        return Collections.unmodifiableList(newList);
    }
}

