/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest;

import com.sk89q.worldguard.WorldGuard;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.ilezzov.namedchest.api.ApiImpl;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.commands.CommandManager;
import ru.ilezzov.namedchest.events.EventManager;
import ru.ilezzov.namedchest.file.PluginFile;
import ru.ilezzov.namedchest.logging.Logger;
import ru.ilezzov.namedchest.logging.PaperLogger;
import ru.ilezzov.namedchest.managers.BlockHoverManager;
import ru.ilezzov.namedchest.managers.BlockTypeManager;
import ru.ilezzov.namedchest.managers.VersionManager;
import ru.ilezzov.namedchest.messages.ConsoleMessages;
import ru.ilezzov.namedchest.settings.PluginSettings;
import ru.ilezzov.namedchest.stats.PluginStats;
import ru.ilezzov.namedchest.utils.ListUtils;

public final class Main
extends JavaPlugin {
    private static NamedChestAPI api;
    private static Logger pluginLogger;
    private static Main instance;
    private static PluginSettings pluginSettings;
    private static String prefix;
    private static String pluginVersion;
    private static String pluginContactLink;
    private static List<String> pluginDevelopers;
    private static boolean outdatedVersion;
    private static String messageLanguage;
    private static boolean supportWorldGuard;
    private static PluginFile configFile;
    private static PluginFile messagesFile;
    private static VersionManager versionManager;
    private static BlockTypeManager blockTypeManager;
    private static BlockHoverManager blockHoverManager;
    private static EventManager eventManager;
    private static WorldGuard worldGuard;

    public void onEnable() {
        pluginLogger = new PaperLogger(this);
        instance = this;
        api = Main.loadApi();
        this.loadSettings();
        Main.loadFiles();
        this.loadPluginInfo();
        Main.checkPluginVersion();
        Main.loadWorldGuard();
        this.loadManagers();
        CommandManager.loadCommands();
        this.loadEvents();
        this.loadMetrics();
        this.sendEnableMessage();
    }

    public void onDisable() {
        if (blockHoverManager != null) {
            blockHoverManager.stopTask();
            blockHoverManager.killAll();
        }
    }

    public static void checkPluginVersion() {
        if (configFile.getBoolean("check_updates")) {
            try {
                versionManager = new VersionManager(pluginVersion, pluginSettings.getUrlToFileVersion());
                if (versionManager.check()) {
                    pluginLogger.info(ConsoleMessages.latestPluginVersion(pluginVersion));
                    outdatedVersion = false;
                } else {
                    pluginLogger.info(ConsoleMessages.legacyPluginVersion(pluginVersion, versionManager.getCurrentPluginVersion(), pluginSettings.getUrlToDownloadLatestVersion()));
                    outdatedVersion = true;
                }
            }
            catch (URISyntaxException e) {
                pluginLogger.info(ConsoleMessages.errorOccurred("Invalid link to the GitHub file. link = ".concat(versionManager.getUrlToFileVersion())));
            }
            catch (IOException | InterruptedException e) {
                pluginLogger.info(ConsoleMessages.errorOccurred("Couldn't send a request to get the plugin version"));
            }
        }
    }

    public static void loadWorldGuard() {
        boolean supportWorldGuard = configFile.getBoolean("support_worldguard");
        if (!supportWorldGuard) {
            return;
        }
        Plugin worldGuardPlugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (worldGuardPlugin == null) {
            return;
        }
        worldGuard = WorldGuard.getInstance();
        Main.setSupportWorldGuard(true);
        pluginLogger.info(ConsoleMessages.supportedWorldGuard());
    }

    private void loadSettings() {
        try {
            pluginSettings = new PluginSettings();
        }
        catch (IOException e) {
            pluginLogger.info(ConsoleMessages.errorOccurred(e.getMessage()));
        }
    }

    public static void loadFiles() {
        configFile = new PluginFile(Main.getInstance(), "config.yml");
        messageLanguage = configFile.getString("language");
        messagesFile = new PluginFile(Main.getInstance(), "messages/".concat(messageLanguage).concat(".yml"));
    }

    public static NamedChestAPI loadApi() {
        return new ApiImpl();
    }

    private void loadEvents() {
        eventManager = new EventManager(this);
        eventManager.loadEvents();
    }

    private void loadPluginInfo() {
        prefix = Main.getMessagesFile().getString("Plugin.plugin-prefix");
        pluginVersion = this.getDescription().getVersion();
        pluginDevelopers = this.getDescription().getAuthors();
        pluginContactLink = this.getDescription().getWebsite();
    }

    public static void reloadPluginInfo() {
        prefix = Main.getMessagesFile().getString("Plugin.plugin-prefix");
    }

    private void loadManagers() {
        blockTypeManager = new BlockTypeManager();
        blockHoverManager = new BlockHoverManager();
    }

    private void loadMetrics() {
        new PluginStats(this);
    }

    private void sendEnableMessage() {
        pluginLogger.info(ConsoleMessages.pluginEnable(ListUtils.listToString(Main.getPluginDevelopers()), Main.getPluginVersion(), Main.getPluginContactLink()));
    }

    @Generated
    public static NamedChestAPI getApi() {
        return api;
    }

    @Generated
    public static Logger getPluginLogger() {
        return pluginLogger;
    }

    @Generated
    public static Main getInstance() {
        return instance;
    }

    @Generated
    public static PluginSettings getPluginSettings() {
        return pluginSettings;
    }

    @Generated
    public static String getPrefix() {
        return prefix;
    }

    @Generated
    public static String getPluginVersion() {
        return pluginVersion;
    }

    @Generated
    public static String getPluginContactLink() {
        return pluginContactLink;
    }

    @Generated
    public static List<String> getPluginDevelopers() {
        return pluginDevelopers;
    }

    @Generated
    public static boolean isOutdatedVersion() {
        return outdatedVersion;
    }

    @Generated
    public static String getMessageLanguage() {
        return messageLanguage;
    }

    @Generated
    public static boolean isSupportWorldGuard() {
        return supportWorldGuard;
    }

    @Generated
    public static void setSupportWorldGuard(boolean supportWorldGuard) {
        Main.supportWorldGuard = supportWorldGuard;
    }

    @Generated
    public static PluginFile getConfigFile() {
        return configFile;
    }

    @Generated
    public static PluginFile getMessagesFile() {
        return messagesFile;
    }

    @Generated
    public static VersionManager getVersionManager() {
        return versionManager;
    }

    @Generated
    public static BlockTypeManager getBlockTypeManager() {
        return blockTypeManager;
    }

    @Generated
    public static BlockHoverManager getBlockHoverManager() {
        return blockHoverManager;
    }

    @Generated
    public static EventManager getEventManager() {
        return eventManager;
    }

    @Generated
    public static WorldGuard getWorldGuard() {
        return worldGuard;
    }

    static {
        supportWorldGuard = false;
    }
}

