/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.api;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.flattener.FlattenerListener;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.api.Response;
import ru.ilezzov.namedchest.api.Status;

public class ApiImpl
implements NamedChestAPI {
    @Override
    public Response checkBlock(Block block, boolean checkDisplayName) {
        if (block == null) {
            return new Response(Status.NULL_BLOCK, null);
        }
        if (!Main.getBlockTypeManager().contains(block.getType())) {
            return new Response(Status.INVALUABLE_BLOCK, null);
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Container)) {
            return new Response(Status.INVALUABLE_BLOCK, null);
        }
        Container container = (Container)blockState;
        if (checkDisplayName && container.customName() == null) {
            return new Response(Status.NULL_DISPLAY_NAME, null);
        }
        return new Response(Status.ACCESS, container);
    }

    @Override
    public void setName(Component name, Container container) {
        container.customName(name);
        container.update(true, true);
    }

    @Override
    public void removeName(Container container) {
        this.setName(null, container);
    }

    @Override
    public int componentLength(Component component) {
        Accumulator accumulator = new Accumulator();
        ComponentFlattener.basic().flatten(component, (FlattenerListener)accumulator);
        return accumulator.length;
    }

    @Override
    public boolean isPlayerInRegion(Player player, Location location) {
        WorldGuard worldGuard = Main.getWorldGuard();
        if (worldGuard == null) {
            return false;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = worldGuard.getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regionManager == null) {
            return false;
        }
        ApplicableRegionSet regions = regionManager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location));
        if (regions.size() == 0) {
            return true;
        }
        for (ProtectedRegion region : regions) {
            if (!region.isOwner(localPlayer) && !region.isMember(localPlayer)) continue;
            return true;
        }
        return false;
    }

    private static final class Accumulator
    implements FlattenerListener {
        private int length = 0;

        private Accumulator() {
        }

        public void component(String text) {
            this.length += text.length();
        }
    }
}

