/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.commands.executors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.api.Response;
import ru.ilezzov.namedchest.commands.CommandManager;
import ru.ilezzov.namedchest.managers.CooldownManager;
import ru.ilezzov.namedchest.managers.VersionManager;
import ru.ilezzov.namedchest.messages.PluginMessages;
import ru.ilezzov.namedchest.permission.Permission;
import ru.ilezzov.namedchest.permission.PermissionsChecker;
import ru.ilezzov.namedchest.placeholder.PluginPlaceholder;
import ru.ilezzov.namedchest.utils.LegacySerialize;
import ru.ilezzov.namedchest.utils.ListUtils;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private final FileConfiguration configuration = Main.getConfigFile().getConfig();
    private final ConfigurationSection nameSettings = this.configuration.getConfigurationSection("name_settings");
    private final ConfigurationSection commandSettings = this.configuration.getConfigurationSection("command_settings");
    private final PluginPlaceholder commandPlaceholders = new PluginPlaceholder();
    private final CooldownManager cooldownManager = new CooldownManager(this.commandSettings.getLong("cooldown"));
    private final boolean enableSetCommand = this.commandSettings.getBoolean("enable_set");
    private final boolean enableRemoveCommand = this.commandSettings.getBoolean("enable_clear");
    private final boolean supportColor = this.nameSettings.getBoolean("support_color");
    private final boolean supportSpaces = this.nameSettings.getBoolean("support_spaces");
    private final int maxNameLength = this.nameSettings.getInt("max_name_length");
    private final int maxDistance = this.configuration.getInt("max_distance");
    private final NamedChestAPI api = Main.getApi();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        this.commandPlaceholders.addPlaceholder("{DEVELOPER}", ListUtils.listToString(Main.getPluginDevelopers()));
        this.commandPlaceholders.addPlaceholder("{CONTACT_LINK}", Main.getPluginContactLink());
        if (args.length == 0) {
            return this.handleHelp(sender);
        }
        return switch (args[0]) {
            case "reload" -> this.handleReload(sender);
            case "version" -> this.handleVersion(sender);
            case "set" -> this.handleSet(sender, args);
            case "clear" -> this.handleClear(sender);
            default -> this.handleHelp(sender);
        };
    }

    private boolean handleHelp(@NotNull CommandSender sender) {
        sender.sendMessage(PluginMessages.commandMainCommandMessage(this.commandPlaceholders));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!PermissionsChecker.hasPermission(sender, Permission.RELOAD)) {
            sender.sendMessage(PluginMessages.pluginNoPermsMessage(this.commandPlaceholders));
            return true;
        }
        Main.loadFiles();
        Main.reloadPluginInfo();
        Main.checkPluginVersion();
        Main.loadWorldGuard();
        Main.getBlockTypeManager().reload();
        Main.getBlockHoverManager().killAll();
        CommandManager.loadCommands();
        Main.getEventManager().reloadEvents();
        this.commandPlaceholders.addPlaceholder("{P}", Main.getPrefix());
        sender.sendMessage(PluginMessages.pluginReloadMessage(this.commandPlaceholders));
        return true;
    }

    public boolean handleVersion(CommandSender sender) {
        VersionManager versionManager = Main.getVersionManager();
        if (versionManager == null) {
            sender.sendMessage(PluginMessages.pluginHasErrorCheckVersionMessage(this.commandPlaceholders));
            return true;
        }
        this.commandPlaceholders.addPlaceholder("{LATEST_VERS}", versionManager.getCurrentPluginVersion());
        if (Main.isOutdatedVersion()) {
            this.commandPlaceholders.addPlaceholder("{DOWNLOAD_LINK}", Main.getPluginSettings().getUrlToDownloadLatestVersion());
            this.commandPlaceholders.addPlaceholder("{OUTDATED_VERS}", Main.getPluginVersion());
            sender.sendMessage(PluginMessages.pluginUseOutdatedVersionMessage(this.commandPlaceholders));
            return true;
        }
        sender.sendMessage(PluginMessages.pluginUseLatestVersionMessage(this.commandPlaceholders));
        return true;
    }

    private boolean handleSet(CommandSender sender, String[] args) {
        if (!this.enableSetCommand) {
            sender.sendMessage(PluginMessages.commandDisableCommandMessage(this.commandPlaceholders));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(PluginMessages.pluginNoConsoleMessage(this.commandPlaceholders));
            return true;
        }
        Player player = (Player)sender;
        if (!PermissionsChecker.hasPermission(sender, Permission.NAME_SET, Permission.NAME_SET_COLOR)) {
            sender.sendMessage(PluginMessages.pluginNoPermsMessage(this.commandPlaceholders));
            return true;
        }
        if (this.cooldownManager.checkCooldown(player.getUniqueId())) {
            this.commandPlaceholders.addPlaceholder("{TIME}", this.cooldownManager.getRemainingTime(player.getUniqueId()));
            sender.sendMessage(PluginMessages.pluginCommandCooldownMessage(this.commandPlaceholders));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(PluginMessages.commandNameEmpty(this.commandPlaceholders));
            return true;
        }
        Block block = player.getTargetBlock(this.maxDistance);
        Response response = this.api.checkBlock(block, false);
        if (Main.isSupportWorldGuard() && !PermissionsChecker.hasPermission(sender, Permission.IGNORE_REGIONS) && !this.api.isPlayerInRegion(player, block.getLocation())) {
            player.sendMessage(PluginMessages.commandNotOwnedRegion(this.commandPlaceholders));
            return true;
        }
        switch (response.status()) {
            case NULL_BLOCK: {
                sender.sendMessage(PluginMessages.commandNameBlockNull(this.commandPlaceholders));
                break;
            }
            case ACCESS: {
                String textName = this.getTextName(args);
                if (textName == null) {
                    sender.sendMessage(PluginMessages.commandNameEmpty(this.commandPlaceholders));
                    return true;
                }
                Object name = this.supportColor ? (PermissionsChecker.hasPermission(sender, Permission.NAME_SET_COLOR) ? LegacySerialize.serialize(textName) : Component.text((String)textName)) : Component.text((String)textName);
                if (PermissionsChecker.hasPermission(sender, Permission.NAME_MAX_LENGTH)) {
                    this.api.setName((Component)name, (Container)response.data());
                    Material material = block.getType();
                    this.commandPlaceholders.addPlaceholder("{BLOCK}", material);
                    this.commandPlaceholders.addPlaceholder("{NAME}", LegacyComponentSerializer.legacySection().serialize((Component)name));
                    sender.sendMessage(PluginMessages.commandNameSet(this.commandPlaceholders));
                } else {
                    int componentLength = this.api.componentLength((Component)name);
                    if (componentLength > this.maxNameLength) {
                        this.commandPlaceholders.addPlaceholder("{MAX_LENGTH}", this.maxNameLength);
                        sender.sendMessage(PluginMessages.commandNameMaxLength(this.commandPlaceholders));
                    } else {
                        this.api.setName((Component)name, (Container)response.data());
                        Material material = block.getType();
                        this.commandPlaceholders.addPlaceholder("{BLOCK}", material);
                        this.commandPlaceholders.addPlaceholder("{NAME}", LegacyComponentSerializer.legacySection().serialize((Component)name));
                        sender.sendMessage(PluginMessages.commandNameSet(this.commandPlaceholders));
                    }
                }
                this.newCooldown((CommandSender)player);
                return true;
            }
        }
        return true;
    }

    private String getTextName(String[] args) {
        String firstWorld = args[1];
        if (firstWorld == null || firstWorld.isBlank()) {
            return null;
        }
        if (!this.supportSpaces) {
            return firstWorld;
        }
        return String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
    }

    private boolean handleClear(CommandSender sender) {
        if (!this.enableRemoveCommand) {
            sender.sendMessage(PluginMessages.commandDisableCommandMessage(this.commandPlaceholders));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(PluginMessages.pluginNoConsoleMessage(this.commandPlaceholders));
            return true;
        }
        Player player = (Player)sender;
        if (!PermissionsChecker.hasPermission(sender, Permission.NAME_CLEAR)) {
            sender.sendMessage(PluginMessages.pluginNoPermsMessage(this.commandPlaceholders));
            return true;
        }
        if (this.cooldownManager.checkCooldown(player.getUniqueId())) {
            this.commandPlaceholders.addPlaceholder("{TIME}", this.cooldownManager.getRemainingTime(player.getUniqueId()));
            sender.sendMessage(PluginMessages.pluginCommandCooldownMessage(this.commandPlaceholders));
            return true;
        }
        Block block = player.getTargetBlock(this.maxDistance);
        Response response = this.api.checkBlock(block, true);
        if (Main.isSupportWorldGuard() && !PermissionsChecker.hasPermission(sender, Permission.IGNORE_REGIONS) && !this.api.isPlayerInRegion(player, block.getLocation())) {
            player.sendMessage(PluginMessages.commandNotOwnedRegion(this.commandPlaceholders));
            return true;
        }
        switch (response.status()) {
            case NULL_BLOCK: {
                sender.sendMessage(PluginMessages.commandNameBlockNull(this.commandPlaceholders));
                break;
            }
            case INVALUABLE_BLOCK: {
                sender.sendMessage(PluginMessages.commandNameBlockError(this.commandPlaceholders));
                break;
            }
            case NULL_DISPLAY_NAME: {
                sender.sendMessage(PluginMessages.commandNameAlreadyClear(this.commandPlaceholders));
                break;
            }
            case ACCESS: {
                this.api.removeName((Container)response.data());
                Main.getBlockHoverManager().kill(block.getLocation());
                Material material = block.getType();
                this.commandPlaceholders.addPlaceholder("{BLOCK}", material);
                sender.sendMessage(PluginMessages.commandNameClear(this.commandPlaceholders));
                this.newCooldown((CommandSender)player);
                return true;
            }
        }
        return true;
    }

    private void newCooldown(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        if (PermissionsChecker.hasPermission((CommandSender)player, Permission.NO_COOLDOWN)) {
            return;
        }
        this.cooldownManager.newCooldown(player.getUniqueId());
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partialName = args[0];
            if ("version".startsWith(partialName)) {
                completions.add("version");
            }
            if (PermissionsChecker.hasPermission(sender, Permission.RELOAD) && "reload".startsWith(partialName)) {
                completions.add("reload");
            }
            if (PermissionsChecker.hasPermission(sender, Permission.NAME_SET, Permission.NAME_SET_COLOR) && "set".startsWith(partialName)) {
                completions.add("set");
            }
            if (PermissionsChecker.hasPermission(sender, Permission.NAME_CLEAR) && "clear".startsWith(partialName)) {
                completions.add("clear");
            }
        }
        return completions;
    }
}

