/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.events.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.api.Response;
import ru.ilezzov.namedchest.api.Status;
import ru.ilezzov.namedchest.messages.PluginMessages;
import ru.ilezzov.namedchest.permission.Permission;
import ru.ilezzov.namedchest.permission.PermissionsChecker;
import ru.ilezzov.namedchest.placeholder.PluginPlaceholder;
import ru.ilezzov.namedchest.utils.LegacySerialize;

public class PlayerClickEvent
implements Listener {
    private final NamedChestAPI api = Main.getApi();
    private final PluginPlaceholder placeholder = new PluginPlaceholder();
    private final FileConfiguration configuration = Main.getConfigFile().getConfig();
    private final ConfigurationSection nameSettings = this.configuration.getConfigurationSection("name_settings");
    private final boolean supportColor = this.nameSettings.getBoolean("support_color");
    private final boolean supportSpaces = this.nameSettings.getBoolean("support_spaces");
    private final int maxNameLength = this.nameSettings.getInt("max_name_length");

    @EventHandler
    public void onPlayerClickEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!PermissionsChecker.hasPermission((CommandSender)player, Permission.NAME_SET, Permission.NAME_SET_COLOR)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        if (itemStack.getType() != Material.NAME_TAG) {
            return;
        }
        Block block = event.getClickedBlock();
        Response response = this.api.checkBlock(block, false);
        if (Main.isSupportWorldGuard() && !PermissionsChecker.hasPermission((CommandSender)player, Permission.IGNORE_REGIONS) && !this.api.isPlayerInRegion(player, block.getLocation())) {
            player.sendMessage(PluginMessages.commandNotOwnedRegion(this.placeholder));
            return;
        }
        if (response.status() != Status.ACCESS) {
            return;
        }
        event.setCancelled(true);
        ItemMeta nameTagMeta = itemStack.getItemMeta();
        if (!nameTagMeta.hasDisplayName()) {
            player.sendMessage(PluginMessages.commandNameEmpty(this.placeholder));
            return;
        }
        String textName = nameTagMeta.getDisplayName();
        String[] textNameSplit = textName.split("\\s+");
        if (!this.supportSpaces) {
            textName = textNameSplit[0];
        }
        Object name = this.supportColor ? (PermissionsChecker.hasPermission((CommandSender)player, Permission.NAME_SET_COLOR) ? LegacySerialize.serialize(textName) : Component.text((String)textName)) : Component.text((String)textName);
        if (PermissionsChecker.hasPermission((CommandSender)player, Permission.NAME_MAX_LENGTH)) {
            this.api.setName((Component)name, (Container)response.data());
            Material material = block.getType();
            this.placeholder.addPlaceholder("{BLOCK}", material);
            this.placeholder.addPlaceholder("{NAME}", LegacyComponentSerializer.legacySection().serialize((Component)name));
            player.sendMessage(PluginMessages.commandNameSet(this.placeholder));
        } else {
            int componentLength = this.api.componentLength((Component)name);
            if (componentLength > this.maxNameLength) {
                this.placeholder.addPlaceholder("{MAX_LENGTH}", this.maxNameLength);
                player.sendMessage(PluginMessages.commandNameMaxLength(this.placeholder));
            } else {
                this.api.setName((Component)name, (Container)response.data());
                Material material = block.getType();
                this.placeholder.addPlaceholder("{BLOCK}", material);
                this.placeholder.addPlaceholder("{NAME}", LegacyComponentSerializer.legacySection().serialize((Component)name));
                player.sendMessage(PluginMessages.commandNameSet(this.placeholder));
            }
        }
        this.removeTagFromInventory(player, itemStack);
    }

    private void removeTagFromInventory(Player player, ItemStack nameTag) {
        String displayName = nameTag.getItemMeta().getDisplayName();
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemMeta itemMeta;
            ItemStack itemStack = player.getInventory().getItem(i);
            if (itemStack == null || itemStack.getAmount() < 1 || itemStack.getType() != nameTag.getType() || !itemStack.hasItemMeta() || !(itemMeta = itemStack.getItemMeta()).hasDisplayName() || !itemMeta.getDisplayName().equals(displayName)) continue;
            itemStack.setAmount(itemStack.getAmount() - 1);
            player.getInventory().setItem(i, itemStack);
            break;
        }
    }
}

