/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.events.listeners;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.managers.BlockHoverManager;

public class PlayerHoverEvent
implements Listener {
    private final NamedChestAPI api = Main.getApi();
    private final BlockHoverManager blockHoverManager = Main.getBlockHoverManager();
    private final int maxDistance = Main.getConfigFile().getInt("max_distance");

    @EventHandler
    public void onPLayerHoverEvent(ru.ilezzov.namedchest.events.model.PlayerHoverEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Container container = event.getContainer();
        if (this.blockHoverManager.contains(block.getLocation())) {
            return;
        }
        this.showTextDisplay(player, block, container);
    }

    private void showTextDisplay(Player player, Block block, Container container) {
        Entity textEntity = this.spawnTextEntity(player, block, container);
        this.blockHoverManager.add(block.getLocation(), textEntity);
        this.startShowTextController(player, textEntity, block.getLocation());
    }

    private Entity spawnTextEntity(Player player, Block block, Container container) {
        BlockFace blockFace = this.getCardinalDirection(player);
        Location location = switch (blockFace) {
            case BlockFace.NORTH -> block.getLocation().add(0.5, 0.2, 1.0);
            case BlockFace.WEST -> block.getLocation().add(1.0, 0.2, 0.5);
            case BlockFace.EAST -> block.getLocation().add(-0.2, 0.2, 0.5);
            case BlockFace.SOUTH -> block.getLocation().add(0.5, 0.2, -0.2);
            default -> block.getLocation().add(0.5, 0.5, 0.5);
        };
        return block.getWorld().spawn(location, ArmorStand.class, entity -> {
            entity.customName(container.customName());
            entity.setVisible(false);
            entity.setInvulnerable(true);
            entity.setGravity(false);
            entity.setCustomNameVisible(true);
            entity.setMarker(true);
            entity.setSmall(true);
        });
    }

    private BlockFace getCardinalDirection(Player player) {
        float yaw = player.getLocation().getYaw();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return BlockFace.WEST;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return BlockFace.NORTH;
        }
        if (yaw >= 225.0f) {
            return BlockFace.EAST;
        }
        return BlockFace.SOUTH;
    }

    private void startShowTextController(final Player player, final Entity textDisplay, final Location location) {
        new BukkitRunnable(){

            public void run() {
                Block targetBlock = player.getTargetBlockExact(PlayerHoverEvent.this.maxDistance);
                if (!player.isOnline()) {
                    Main.getBlockHoverManager().remove(location);
                    textDisplay.remove();
                    this.cancel();
                    return;
                }
                if (targetBlock == null) {
                    Main.getBlockHoverManager().remove(location);
                    textDisplay.remove();
                    this.cancel();
                    return;
                }
                if (targetBlock.getLocation().equals((Object)location)) {
                    return;
                }
                PlayerHoverEvent.this.blockHoverManager.remove(location);
                textDisplay.remove();
                this.cancel();
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 5L);
    }
}

