/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.events.listeners;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.managers.VersionManager;
import ru.ilezzov.namedchest.messages.PluginMessages;
import ru.ilezzov.namedchest.permission.PermissionsChecker;
import ru.ilezzov.namedchest.placeholder.PluginPlaceholder;

public class VersionCheckEvent
implements Listener {
    private final PluginPlaceholder eventPlaceholders = new PluginPlaceholder();
    private final boolean isEnable = Main.getConfigFile().getBoolean("check_updates");

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        if (!this.isEnable) {
            return;
        }
        if (!Main.isOutdatedVersion()) {
            return;
        }
        Player player = event.getPlayer();
        if (!PermissionsChecker.hasPermission((CommandSender)player)) {
            return;
        }
        VersionManager versionManager = Main.getVersionManager();
        if (versionManager == null) {
            player.sendMessage(PluginMessages.pluginHasErrorCheckVersionMessage(this.eventPlaceholders));
            return;
        }
        this.eventPlaceholders.addPlaceholder("{OUTDATED_VERS}", Main.getPluginVersion());
        this.eventPlaceholders.addPlaceholder("{LATEST_VERS}", versionManager.getCurrentPluginVersion());
        this.eventPlaceholders.addPlaceholder("{DOWNLOAD_LINK}", Main.getPluginSettings().getUrlToDownloadLatestVersion());
        player.sendMessage(PluginMessages.pluginUseOutdatedVersionMessage(this.eventPlaceholders));
    }
}

