/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class LegacySerialize {
    private static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("\u00a7[0-9a-fk-orA-FK-OR]");
    private static final Pattern LEGACY_HEX_PATTERN = Pattern.compile("\u00a7#([0-9A-Fa-f]{6})");
    private static final Pattern LEGACY_HEX_PARAGRAPH_PATTERN = Pattern.compile("\u00a7x(\u00a7([0-9A-Fa-f])){6}");
    private static final Pattern LEGACY_ADVANCED_COLOR = Pattern.compile("##([a-fA-F\\d]{6})");
    private static final Map<String, String> COLORS = Map.ofEntries(Map.entry("\u00a70", "#000000"), Map.entry("\u00a71", "#0000AA"), Map.entry("\u00a72", "#00AA00"), Map.entry("\u00a73", "#00AAAA"), Map.entry("\u00a74", "#AA0000"), Map.entry("\u00a75", "#AA00AA"), Map.entry("\u00a76", "#FFAA00"), Map.entry("\u00a77", "#AAAAAA"), Map.entry("\u00a78", "#555555"), Map.entry("\u00a79", "#5555FF"), Map.entry("\u00a7a", "#55FF55"), Map.entry("\u00a7b", "#55FFFF"), Map.entry("\u00a7c", "#FF5555"), Map.entry("\u00a7d", "#FF55FF"), Map.entry("\u00a7e", "#FFFF55"), Map.entry("\u00a7f", "#FFFFFF"), Map.entry("\u00a7k", "obf"), Map.entry("\u00a7l", "b"), Map.entry("\u00a7m", "st"), Map.entry("\u00a7n", "u"), Map.entry("\u00a7o", "i"), Map.entry("\u00a7r", "reset"));

    public static Component serialize(String message) {
        if (message == null) {
            return Component.empty();
        }
        return MiniMessage.miniMessage().deserialize((Object)LegacySerialize.legacySerialize(message));
    }

    public static String serializeToString(String message) {
        if (message == null) {
            return "";
        }
        return LegacySerialize.legacySerialize(message);
    }

    private static String legacySerialize(String message) {
        String serializeMessage = LegacySerialize.translateAlternateCodeColor('&', message);
        serializeMessage = LegacySerialize.replaceLegacyParagraphHex(serializeMessage);
        serializeMessage = LegacySerialize.replaceLegacyAdvancedColor(serializeMessage);
        serializeMessage = LegacySerialize.replaceLegacyHex(serializeMessage);
        serializeMessage = LegacySerialize.replaceLegacyColor(serializeMessage);
        return serializeMessage;
    }

    private static String replaceLegacyAdvancedColor(String s) {
        Matcher matcher = LEGACY_ADVANCED_COLOR.matcher(s);
        StringBuilder result = new StringBuilder(s.length());
        int lastIndex = 0;
        while (matcher.find()) {
            result.append(s, lastIndex, matcher.start()).append("#").append(matcher.group(1));
            lastIndex = matcher.end();
        }
        result.append(s, lastIndex, s.length());
        return result.toString();
    }

    private static String replaceLegacyParagraphHex(String s) {
        Matcher matcher = LEGACY_HEX_PARAGRAPH_PATTERN.matcher(s);
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            String hexColor = matcher.group().replace("\u00a7x", "").replace("\u00a7", "");
            result.append(s, lastIndex, matcher.start()).append("<#").append(hexColor).append(">");
            lastIndex = matcher.end();
        }
        result.append(s, lastIndex, s.length());
        return result.toString();
    }

    private static String replaceLegacyHex(String s) {
        Matcher matcher = LEGACY_HEX_PATTERN.matcher(s);
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            result.append(s, lastIndex, matcher.start()).append("<#").append(matcher.group(1)).append(">");
            lastIndex = matcher.end();
        }
        result.append(s, lastIndex, s.length());
        return result.toString();
    }

    private static String replaceLegacyColor(String s) {
        Matcher matcher = LEGACY_COLOR_PATTERN.matcher(s);
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            String replacement = COLORS.getOrDefault(matcher.group(), matcher.group());
            result.append(s, lastIndex, matcher.start()).append("<").append(replacement).append(">");
            lastIndex = matcher.end();
        }
        result.append(s, lastIndex, s.length());
        return result.toString();
    }

    private static String translateAlternateCodeColor(char code, String s) {
        char[] b = s.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != code || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx#".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }
}

