/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.events;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.events.listeners.PlayerBlockBreakEvent;
import ru.ilezzov.namedchest.events.listeners.PlayerClickEvent;
import ru.ilezzov.namedchest.events.listeners.PlayerHoverEvent;
import ru.ilezzov.namedchest.events.listeners.PlayerUseAnvilEvent;
import ru.ilezzov.namedchest.events.listeners.VersionCheckEvent;
import ru.ilezzov.namedchest.logging.Logger;
import ru.ilezzov.namedchest.messages.ConsoleMessages;

public class EventManager {
    private final Logger logger = Main.getPluginLogger();
    private final JavaPlugin plugin;
    private Map<Class<? extends Listener>, Boolean> listenerClasses;
    private Map<String, Object> events;

    public EventManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.events = new HashMap<String, Object>();
        this.listenerClasses = this.loadListenerClasses();
    }

    public Object get(String eventName) {
        return this.events.get(eventName);
    }

    public void loadEvents() {
        HashMap<String, Object> events = new HashMap<String, Object>();
        for (Class<? extends Listener> listenerClass : this.listenerClasses.keySet()) {
            try {
                if (!this.listenerClasses.get(listenerClass).booleanValue()) continue;
                Listener listener = listenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
                events.put(listenerClass.getSimpleName(), listener);
                this.logger.info(ConsoleMessages.eventLoaded(listenerClass.getSimpleName()));
            }
            catch (Exception e) {
                this.logger.info(ConsoleMessages.errorOccurred(String.format("Couldn't load event %s", listenerClass.getSimpleName())));
            }
        }
        this.events = events;
    }

    public void reloadEvents() {
        HandlerList.unregisterAll((Plugin)this.plugin);
        this.listenerClasses = this.loadListenerClasses();
        this.loadEvents();
    }

    private Map<Class<? extends Listener>, Boolean> loadListenerClasses() {
        FileConfiguration config = Main.getConfigFile().getConfig();
        ConfigurationSection nameSettings = config.getConfigurationSection("name_settings");
        return Map.ofEntries(this.eventEntry(VersionCheckEvent.class, true), this.eventEntry(PlayerClickEvent.class, true), this.eventEntry(PlayerHoverEvent.class, true), this.eventEntry(PlayerBlockBreakEvent.class, !nameSettings.getBoolean("save_for_breaking")), this.eventEntry(PlayerUseAnvilEvent.class, nameSettings.getBoolean("cancel_anvil")));
    }

    private Map.Entry<Class<? extends Listener>, Boolean> eventEntry(Class<? extends Listener> eventClass, Boolean enable) {
        return Map.entry(eventClass, enable);
    }
}

