/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.api;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.flattener.FlattenerListener;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.api.Response;
import ru.ilezzov.namedchest.api.Status;

public class ApiImpl
implements NamedChestAPI {
    @Override
    public Response checkBlock(Block block) {
        if (block == null) {
            return new Response(Status.NULL_BLOCK, null);
        }
        if (!Main.getBlockTypeManager().contains(block.getType())) {
            return new Response(Status.INVALUABLE_BLOCK, null);
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Container)) {
            return new Response(Status.INVALUABLE_BLOCK, null);
        }
        Container container = (Container)blockState;
        return new Response(Status.ACCESS, container);
    }

    @Override
    public void setName(Component name, Container container) {
        container.customName(name);
        container.update(true, true);
    }

    @Override
    public void removeName(Container container) {
        this.setName(null, container);
    }

    @Override
    public int componentLength(Component component) {
        Accumulator accumulator = new Accumulator();
        ComponentFlattener.basic().flatten(component, (FlattenerListener)accumulator);
        return accumulator.length;
    }

    private static final class Accumulator
    implements FlattenerListener {
        private int length = 0;

        private Accumulator() {
        }

        public void component(String text) {
            this.length += text.length();
        }
    }
}

