/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.commands;

import java.util.Map;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.commands.executors.MainCommand;
import ru.ilezzov.namedchest.logging.Logger;
import ru.ilezzov.namedchest.messages.ConsoleMessages;

public class CommandManager {
    private static final Logger logger = Main.getPluginLogger();
    private static final JavaPlugin plugin = Main.getInstance();

    public static void loadCommands() {
        Map<String, CommandExecutor> commands = CommandManager.getCommands();
        for (String commandName : commands.keySet()) {
            PluginCommand command = plugin.getCommand(commandName);
            if (command != null) {
                CommandExecutor commandExecutor = commands.get(commandName);
                command.setExecutor(commandExecutor);
                if (!(commandExecutor instanceof TabCompleter)) continue;
                TabCompleter completer = (TabCompleter)commandExecutor;
                command.setTabCompleter(completer);
                continue;
            }
            logger.info(ConsoleMessages.errorOccurred(String.format("The command %s was not found in plugin.yml", commandName)));
        }
    }

    private static Map<String, CommandExecutor> getCommands() {
        return Map.ofEntries(Map.entry("namedchest", new MainCommand()));
    }
}

