/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.logging.Logger;
import ru.ilezzov.namedchest.messages.ConsoleMessages;

public class PluginFile {
    private final JavaPlugin plugin;
    private final String fileName;
    private final Logger LOGGER = Main.getPluginLogger();
    private FileConfiguration config;
    private File file;
    private String configVersion;

    public PluginFile(JavaPlugin plugin, String fileName) {
        this.plugin = plugin;
        this.fileName = fileName;
        if (!this.createConfig()) {
            this.configVersion = this.config.getString("config_version");
            this.checkVersion();
        }
    }

    private boolean createConfig() {
        this.file = new File(this.plugin.getDataFolder(), this.fileName);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource(this.fileName, false);
            this.LOGGER.info(ConsoleMessages.createNewFile(this.fileName));
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
            return true;
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        return false;
    }

    private void checkVersion() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.fileName);){
            if (inputStream == null) {
                return;
            }
            YamlConfiguration defaultConfigFile = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String defaultConfigFileVersion = defaultConfigFile.getString("config_version");
            if (defaultConfigFileVersion == null) {
                this.LOGGER.info("");
                return;
            }
            if (this.equalsVersion(defaultConfigFileVersion, this.configVersion) == 1) {
                this.addMissingKeys(defaultConfigFile);
                this.LOGGER.info(ConsoleMessages.addNewKeysToFile(this.fileName));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addMissingKeys(YamlConfiguration defaultConfigFile) {
        boolean isUpdate = false;
        for (String key : defaultConfigFile.getKeys(true)) {
            if (this.config.contains(key)) continue;
            this.getConfig().set(key, defaultConfigFile.get(key));
            isUpdate = true;
        }
        if (isUpdate) {
            this.getConfig().set("config_version", defaultConfigFile.get("config_version"));
            this.saveConfig();
        }
    }

    private int equalsVersion(String version1, String version2) {
        String[] version1Split = version1.split("\\.");
        String[] version2Split = version2.split("\\.");
        int maxLength = Math.max(version1Split.length, version2Split.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < version1Split.length ? Integer.parseInt(version1Split[i]) : 0;
            int n = num2 = i < version2Split.length ? Integer.parseInt(version2Split[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reload() {
        this.createConfig();
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public String getString(String key) {
        return this.config.getString(key);
    }

    public int getInt(String key) {
        return this.config.getInt(key);
    }

    public double getDouble(String key) {
        return this.config.getDouble(key);
    }

    public long getLong(String key) {
        return this.config.getLong(key);
    }

    public boolean getBoolean(String key) {
        return this.config.getBoolean(key);
    }

    public <T> List<T> getList(String key, Class<T> tClass) {
        List rawList = this.config.getList(key);
        if (rawList == null) {
            return List.of();
        }
        return rawList.stream().filter(tClass::isInstance).map(tClass::cast).collect(Collectors.toList());
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public String getConfigVersion() {
        return this.configVersion;
    }
}

