/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.managers;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.api.NamedChestAPI;
import ru.ilezzov.namedchest.api.Response;
import ru.ilezzov.namedchest.api.Status;
import ru.ilezzov.namedchest.events.model.PlayerHoverEvent;

public class BlockHoverManager {
    private final NamedChestAPI api = Main.getApi();
    private final Plugin plugin = Main.getInstance();
    private final BukkitTask task;
    private final int maxDistance = Main.getConfigFile().getInt("max_distance");
    private final HashMap<Location, Entity> hoverLocation = new HashMap();

    public BlockHoverManager() {
        this.task = this.startBlockHoverController();
    }

    public void stopTask() {
        this.task.cancel();
    }

    public void killAll() {
        this.hoverLocation.values().forEach(Entity::remove);
    }

    public void add(Location location, Entity entity) {
        this.hoverLocation.put(location, entity);
    }

    public boolean contains(Location location) {
        return this.hoverLocation.containsKey(location);
    }

    public void remove(Location location) {
        this.hoverLocation.remove(location);
    }

    public void kill(Location location) {
        this.hoverLocation.get(location).remove();
    }

    private BukkitTask startBlockHoverController() {
        return Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Container container;
                Block block = player.getTargetBlock(this.maxDistance);
                Response response = this.api.checkBlock(block);
                if (response.status() != Status.ACCESS || (container = (Container)response.data()).customName() == null) continue;
                PlayerHoverEvent event = new PlayerHoverEvent(player, block, container);
                this.callEvent(event);
            }
        }, 0L, 5L);
    }

    private void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }
}

