/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.managers;

import java.util.HashMap;
import java.util.UUID;

public class CooldownManager {
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private final long cooldownTime;

    public CooldownManager(long cooldownTime) {
        this.cooldownTime = cooldownTime * 1000L;
    }

    public void newCooldown(UUID uuid) {
        this.cooldowns.put(uuid, System.currentTimeMillis());
    }

    public long getCooldownTime(UUID uuid) {
        if (!this.check(uuid)) {
            return 0L;
        }
        return this.cooldowns.get(uuid) + this.cooldownTime;
    }

    public boolean checkCooldown(UUID uuid) {
        return this.getCooldownTime(uuid) >= System.currentTimeMillis();
    }

    public int getRemainingTime(UUID uuid) {
        return (int)(this.getCooldownTime(uuid) - System.currentTimeMillis()) / 1000;
    }

    private boolean check(UUID uuid) {
        return this.cooldowns.containsKey(uuid);
    }
}

