/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.managers;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import lombok.Generated;

public class VersionManager {
    private final String localPluginVersion;
    private final String currentPluginVersion;
    private final String urlToFileVersion;

    public VersionManager(String localPluginVersion, String urlToFileVersion) throws URISyntaxException, IOException, InterruptedException {
        this.localPluginVersion = localPluginVersion;
        this.urlToFileVersion = urlToFileVersion;
        this.currentPluginVersion = this.getCurrentPluginVersionFromGitHub();
    }

    public boolean check() throws URISyntaxException, IOException, InterruptedException {
        return this.equalsVersion(this.currentPluginVersion, this.localPluginVersion) != 1;
    }

    private String getCurrentPluginVersionFromGitHub() throws URISyntaxException, IOException, InterruptedException {
        HttpClient httpClient = HttpClient.newHttpClient();
        assert (this.urlToFileVersion != null);
        HttpRequest httpRequest = HttpRequest.newBuilder(new URI(this.urlToFileVersion)).GET().build();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        return httpResponse.body();
    }

    private int equalsVersion(String version1, String version2) {
        String[] version1Split = version1.split("\\.");
        String[] version2Split = version2.split("\\.");
        int maxLength = Math.max(version1Split.length, version2Split.length);
        try {
            for (int i = 0; i < maxLength; ++i) {
                int num2;
                int num1 = i < version1Split.length ? Integer.parseInt(version1Split[i]) : 0;
                int n = num2 = i < version2Split.length ? Integer.parseInt(version2Split[i]) : 0;
                if (num1 < num2) {
                    return -1;
                }
                if (num1 <= num2) continue;
                return 1;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return -2;
        }
    }

    @Generated
    public String getLocalPluginVersion() {
        return this.localPluginVersion;
    }

    @Generated
    public String getCurrentPluginVersion() {
        return this.currentPluginVersion;
    }

    @Generated
    public String getUrlToFileVersion() {
        return this.urlToFileVersion;
    }
}

