/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.ConfigurationSection;
import ru.ilezzov.namedchest.Main;
import ru.ilezzov.namedchest.settings.PluginSettings;
import ru.ilezzov.namedchest.utils.LegacySerialize;

public class ConsoleMessages {
    private static final PluginSettings settings = Main.getPluginSettings();
    private static final ConfigurationSection messages = settings.getSection("Messages");

    public static Component createNewFile(String fileName) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("create-new-file")), fileName);
    }

    public static Component addNewKeysToFile(String fileName) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("add-new-keys-to-file")), fileName);
    }

    public static List<Component> legacyPluginVersion(String outdatedVersion, String latestVersion, String downloadLink) {
        return ConsoleMessages.getComponents(Objects.requireNonNull(messages.getString("legacy-plugin-version")), outdatedVersion, latestVersion, downloadLink);
    }

    public static Component latestPluginVersion(String pluginVersion) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("latest-plugin-version")), pluginVersion);
    }

    public static Component errorOccurred(String errorMessage) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("error-occurred")), errorMessage);
    }

    public static Component successConnectToDatabase() {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("success-connect-to-database")), new Object[0]);
    }

    public static Component databaseError(String errorMessage) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("database-error")), errorMessage);
    }

    public static Component savePlayer(String displayName) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("save-player")), displayName);
    }

    public static Component saveQueue() {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("save-queue")), new Object[0]);
    }

    public static List<Component> pluginEnable(String pluginDeveloper, String pluginVersion, String pluginContactLink) {
        return ConsoleMessages.getComponents(Objects.requireNonNull(messages.getString("plugin-enabled")), pluginDeveloper, pluginVersion, pluginContactLink);
    }

    public static List<Component> pluginDisable(String pluginDeveloper, String pluginVersion, String pluginContactLink) {
        return ConsoleMessages.getComponents(Objects.requireNonNull(messages.getString("plugin-disabled")), pluginDeveloper, pluginVersion, pluginContactLink);
    }

    public static Component eventLoaded(String eventName) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("event-loaded")), eventName);
    }

    public static Component apiLoaded() {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("api-loaded")), new Object[0]);
    }

    public static Component worldLoaded(String world) {
        return ConsoleMessages.getComponent(Objects.requireNonNull(messages.getString("world-loaded")), world);
    }

    private static Component getComponent(String message, Object ... keys) {
        return LegacySerialize.serialize(message.formatted(keys));
    }

    private static List<Component> getComponents(String message, Object ... keys) {
        String[] messageSplit = message.formatted(keys).split("\n");
        ArrayList<Component> components = new ArrayList<Component>();
        for (String text : messageSplit) {
            components.add(LegacySerialize.serialize(text));
        }
        return components;
    }
}

