/*
 * Decompiled with CFR 0.152.
 */
package ru.ilezzov.namedchest.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class PluginSettings {
    private YamlConfiguration file;
    private final String urlToFileVersion;
    private final String urlToDownloadLatestVersion;
    private final boolean bstatsEnable;
    private final int bstatsPluginId;

    public PluginSettings() throws IOException {
        this.loadSettings();
        this.urlToFileVersion = this.getString("Urls.url-to-file-version");
        this.urlToDownloadLatestVersion = this.getString("Urls.url-to-download-latest-version");
        this.bstatsEnable = this.getBoolean("Bstats.enable");
        this.bstatsPluginId = this.getInt("Bstats.plugin-id");
    }

    private void loadSettings() throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("plugin-settings.yml");){
            if (inputStream == null) {
                throw new RuntimeException("Settings.yml cannot be bull");
            }
            this.file = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
    }

    public String getString(String key) {
        return this.file.getString(key);
    }

    public int getInt(String key) {
        return this.file.getInt(key);
    }

    public double getDouble(String key) {
        return this.file.getDouble(key);
    }

    public long getLong(String key) {
        return this.file.getLong(key);
    }

    public boolean getBoolean(String key) {
        return this.file.getBoolean(key);
    }

    public ConfigurationSection getSection(String key) {
        return this.file.getConfigurationSection(key);
    }

    @Generated
    public String getUrlToFileVersion() {
        return this.urlToFileVersion;
    }

    @Generated
    public String getUrlToDownloadLatestVersion() {
        return this.urlToDownloadLatestVersion;
    }

    @Generated
    public boolean isBstatsEnable() {
        return this.bstatsEnable;
    }

    @Generated
    public int getBstatsPluginId() {
        return this.bstatsPluginId;
    }
}

