/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.laserdiamond.ultimatemanhunt.api.event.HuntersReleasedEvent;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.game.GameStateS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.GameTimeS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.HardcoreUpdateS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.HunterGracePeriodDurationS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.TrackingSpeedRunnerS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerDistanceFromHunterS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerGracePeriodDurationS2CPacket;
import net.laserdiamond.ultimatemanhunt.sound.UMSoundEvents;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ultimate_manhunt")
public class UMGame {
    public static final int HUNTER_DETECTION_RANGE = 50;
    private static State currentGameState = State.NOT_STARTED;
    private static int hunterGracePeriodTicks = 1800;
    private static int speedRunnerGracePeriodTicks = 600;
    private static int xSpawnCoordinate = 0;
    private static int zSpawnCoordinate = 0;
    private static boolean friendlyFire = true;
    private static boolean hardcore = false;
    private static boolean windTorchEnabled = true;
    private static PlayerRole newPlayerRole = PlayerRole.SPECTATOR;
    private static PlayerRole deadSpeedRunnerRole = PlayerRole.HUNTER;
    private static final Set<UUID> LOGGED_PLAYER_UUIDS = new HashSet<UUID>();
    private static long currentGameTime = 0L;

    public static State getCurrentGameState() {
        return currentGameState;
    }

    public static void resetGameTime() {
        currentGameTime = 0L;
        UMPackets.sendToAllClients(new GameTimeS2CPacket(0L));
    }

    public static long getCurrentGameTime() {
        return currentGameTime;
    }

    public static boolean areHuntersOnGracePeriod() {
        return currentGameTime < (long)hunterGracePeriodTicks;
    }

    public static Set<UUID> getLoggedPlayerUUIDs() {
        return new HashSet<UUID>(LOGGED_PLAYER_UUIDS);
    }

    public static void wipeLoggedPlayerUUIDs() {
        LOGGED_PLAYER_UUIDS.clear();
    }

    public static void logPlayerUUID(Player player) {
        LOGGED_PLAYER_UUIDS.add(player.getUUID());
    }

    public static boolean containsLoggedPlayerUUID(Player player) {
        return LOGGED_PLAYER_UUIDS.contains(player.getUUID());
    }

    public static void setHunterGracePeriod(int durationTicks) {
        if (durationTicks <= 0) {
            return;
        }
        hunterGracePeriodTicks = durationTicks;
        UMPackets.sendToAllClients(new HunterGracePeriodDurationS2CPacket(durationTicks));
    }

    public static int getHunterGracePeriod() {
        return hunterGracePeriodTicks;
    }

    public static void setSpeedRunnerGracePeriod(int durationTicks) {
        if (durationTicks <= 0) {
            return;
        }
        speedRunnerGracePeriodTicks = durationTicks;
        UMPackets.sendToAllClients(new SpeedRunnerGracePeriodDurationS2CPacket(durationTicks));
    }

    public static int getSpeedRunnerGracePeriod() {
        return speedRunnerGracePeriodTicks;
    }

    public static void setFriendlyFire(boolean friendlyFire) {
        UMGame.friendlyFire = friendlyFire;
    }

    public static boolean isFriendlyFire() {
        return friendlyFire;
    }

    public static void setHardcore(boolean hardcore) {
        UMGame.hardcore = hardcore;
        UMPackets.sendToAllClients(new HardcoreUpdateS2CPacket(hardcore));
    }

    public static boolean isHardcore() {
        return hardcore;
    }

    public static void setXAndZSpawnCoordinate(int x, int z) {
        xSpawnCoordinate = x;
        zSpawnCoordinate = z;
    }

    public static int getXSpawnCoordinate() {
        return xSpawnCoordinate;
    }

    public static int getZSpawnCoordinate() {
        return zSpawnCoordinate;
    }

    public static void setWindTorchEnabled(boolean enabled) {
        windTorchEnabled = enabled;
    }

    public static boolean isWindTorchEnabled() {
        return windTorchEnabled;
    }

    public static void setNewPlayerRole(@NotNull PlayerRole playerRole) {
        newPlayerRole = playerRole;
    }

    public static PlayerRole getNewPlayerRole() {
        return newPlayerRole;
    }

    public static boolean setDeadSpeedRunnerRole(@NotNull PlayerRole playerRole) {
        if (playerRole == PlayerRole.SPEED_RUNNER) {
            return false;
        }
        deadSpeedRunnerRole = playerRole;
        return true;
    }

    public static PlayerRole getDeadSpeedRunnerRole() {
        return deadSpeedRunnerRole;
    }

    public static void sendMessageToAllPlayers(MinecraftServer minecraftServer, Component component) {
        minecraftServer.getPlayerList().getPlayers().forEach(serverPlayer -> serverPlayer.sendSystemMessage(component));
    }

    @SubscribeEvent
    public static void onServerTickPre(TickEvent.ServerTickEvent.Pre event) {
        if (State.isGameRunning()) {
            UMPackets.sendToAllClients(new GameTimeS2CPacket(++currentGameTime));
        }
    }

    @SubscribeEvent
    public static void onPlayerServerTick(TickEvent.PlayerTickEvent.Post event) {
        Player player = event.player;
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        if (currentGameTime == (long)hunterGracePeriodTicks) {
            MinecraftForge.EVENT_BUS.post((Event)new HuntersReleasedEvent());
        }
        player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
            if (umPlayer.isSpectator()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.setGameMode(GameType.SPECTATOR);
                }
            } else if (umPlayer.isHunter() && State.isGameRunning()) {
                player.getFoodData().eat(200, 1.0f);
                if (umPlayer.isBuffedHunter() && player.tickCount % 200 == 0) {
                    player.setHealth(player.getHealth() + 2.0f);
                }
                if (currentGameTime < (long)hunterGracePeriodTicks) {
                    player.teleportTo((double)xSpawnCoordinate, 1000.0, (double)zSpawnCoordinate);
                    return;
                }
                List<Player> speedRunners = UMPlayer.getAvailableSpeedRunners(player);
                if (speedRunners.isEmpty()) {
                    TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                    return;
                }
                for (Player speedRunnerPlayer : speedRunners) {
                    if (UMPlayer.isSpeedRunnerOnGracePeriodServer(player)) continue;
                    if (!player.isAlive()) {
                        SpeedRunnerDistanceFromHunterS2CPacket.sendNotNearHunterPlayer(speedRunnerPlayer);
                        continue;
                    }
                    float distance = player.distanceTo((Entity)speedRunnerPlayer);
                    UMPackets.sendToPlayer(new SpeedRunnerDistanceFromHunterS2CPacket(distance), speedRunnerPlayer);
                    if (distance < 50.0f) {
                        if (!(speedRunnerPlayer instanceof ServerPlayer)) continue;
                        ServerPlayer nearServerPlayer = (ServerPlayer)speedRunnerPlayer;
                        if (!speedRunnerPlayer.isAlive()) continue;
                        int rate = (int)((double)distance / 12.5 + 6.0);
                        if (speedRunnerPlayer.tickCount % rate == 0) {
                            nearServerPlayer.connection.send((Packet)new ClientboundSoundPacket((Holder)UMSoundEvents.HEART_BEAT.getHolder().get(), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 100.0f, 1.0f, level.getRandom().nextLong()));
                        }
                        UMSoundEvents.playDetectionSound(speedRunnerPlayer);
                        continue;
                    }
                    UMSoundEvents.stopDetectionSound(speedRunnerPlayer);
                }
                UUID trackedPlayerUUID = umPlayer.getTrackingPlayerUUID();
                if (trackedPlayerUUID == player.getUUID()) {
                    UMPackets.sendToPlayer(new TrackingSpeedRunnerS2CPacket(false, player, 0.0f), player);
                    return;
                }
                MinecraftServer mcServer = player.getServer();
                if (mcServer == null) {
                    TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                    return;
                }
                ServerPlayer trackedPlayer = mcServer.getPlayerList().getPlayer(trackedPlayerUUID);
                if (trackedPlayer == null) {
                    TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                    return;
                }
                if (!trackedPlayer.level().isClientSide) {
                    UMPlayer trackedPlayerHunter;
                    if (!trackedPlayer.level().dimension().equals((Object)player.level().dimension())) {
                        TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                        return;
                    }
                    if (UMPlayer.isSpeedRunnerOnGracePeriodServer((Player)trackedPlayer)) {
                        TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                        return;
                    }
                    if (!trackedPlayer.isAlive()) {
                        TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                        return;
                    }
                    LazyOptional trackedPlayerCap = trackedPlayer.getCapability(UMPlayerCapability.UM_PLAYER);
                    if (trackedPlayerCap.isPresent() && !(trackedPlayerHunter = (UMPlayer)((Object)((Object)trackedPlayerCap.orElse((Object)new UMPlayer(trackedPlayerUUID))))).isSpeedRunner()) {
                        TrackingSpeedRunnerS2CPacket.sendNonTracking(player);
                        return;
                    }
                }
                float distance = player.distanceTo((Entity)trackedPlayer);
                UMPackets.sendToPlayer(new TrackingSpeedRunnerS2CPacket(true, (Player)trackedPlayer, distance), player);
            }
        });
    }

    public static boolean isNearHunter(Player playerSpeedRunner, Player playerHunter) {
        return playerSpeedRunner.distanceTo((Entity)playerHunter) < 50.0f;
    }

    public static boolean setCurrentGameState(@NotNull State newGameState) {
        if (currentGameState == newGameState) {
            return false;
        }
        if (currentGameState == State.NOT_STARTED && newGameState == State.PAUSED) {
            return false;
        }
        if (currentGameState == State.NOT_STARTED && newGameState == State.IN_PROGRESS) {
            return false;
        }
        if ((currentGameState == State.PAUSED || currentGameState == State.IN_PROGRESS) && newGameState == State.STARTED) {
            return false;
        }
        currentGameState = newGameState;
        UMPackets.sendToAllClients(new GameStateS2CPacket(currentGameState));
        return true;
    }

    public static enum State {
        STARTED,
        IN_PROGRESS,
        PAUSED,
        NOT_STARTED;


        public static boolean isGameRunning() {
            return currentGameState == STARTED || currentGameState == IN_PROGRESS;
        }

        public static boolean isGameNotInProgress() {
            return currentGameState == PAUSED || currentGameState == NOT_STARTED;
        }

        public static boolean hasGameBeenStarted() {
            return State.isGameRunning() || currentGameState == PAUSED;
        }

        public static State fromOrdinal(int value) {
            for (State state : State.values()) {
                if (state.ordinal() != value) continue;
                return state;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String getAsName() {
            Object ret = this.toString().substring(0, 1).toUpperCase() + this.toString().substring(1);
            ret = ((String)ret).replace("_", " ");
            boolean foundSpace = false;
            for (int i = 0; i < ((String)ret).length(); ++i) {
                String s = ((String)ret).substring(i, Math.min(i + 1, ((String)ret).length()));
                if (s.equals(" ")) {
                    foundSpace = true;
                    continue;
                }
                if (!foundSpace) continue;
                ret = ((String)ret).replace(" " + s, " " + s.toUpperCase());
                foundSpace = false;
            }
            return ret;
        }
    }

    public static enum PlayerRole {
        SPECTATOR,
        SPEED_RUNNER,
        HUNTER;


        public static PlayerRole fromString(String value) {
            for (PlayerRole playerRole : PlayerRole.values()) {
                if (!value.equals(playerRole.toString())) continue;
                return playerRole;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String getAsName() {
            Object ret = this.toString().substring(0, 1).toUpperCase() + this.toString().substring(1);
            ret = ((String)ret).replace("_", " ");
            boolean foundSpace = false;
            for (int i = 0; i < ((String)ret).length(); ++i) {
                String s = ((String)ret).substring(i, Math.min(i + 1, ((String)ret).length()));
                if (s.equals(" ")) {
                    foundSpace = true;
                    continue;
                }
                if (!foundSpace) continue;
                ret = ((String)ret).replace(" " + s, " " + s.toUpperCase());
                foundSpace = false;
            }
            return ret;
        }
    }
}

