/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.api.event;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.laserdiamond.ultimatemanhunt.api.event.PlayerGameSpawner;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.HunterReleaseAnnounceS2CPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public class HuntersReleasedEvent
extends Event
implements PlayerGameSpawner {
    private final List<Player> hunters = new LinkedList<Player>();
    private final List<Player> speedRunners = new LinkedList<Player>();
    private final List<Player> spectators = new LinkedList<Player>();

    public HuntersReleasedEvent() {
        UMPlayer.forAllPlayers((player, umPlayer) -> {
            this.speedRunners.add((Player)player);
            if (player.level().isClientSide) {
                return;
            }
            UMPackets.sendToPlayer(new HunterReleaseAnnounceS2CPacket(false), player);
        }, (player, umPlayer) -> {
            this.hunters.add((Player)player);
            if (player.level().isClientSide) {
                return;
            }
            UMPackets.sendToPlayer(new HunterReleaseAnnounceS2CPacket(true), player);
            this.spawn((Player)player);
            List<Player> availablePlayerSpeedRunners = UMPlayer.getAvailableSpeedRunners(player);
            if (!availablePlayerSpeedRunners.isEmpty()) {
                Player trackedPlayer = availablePlayerSpeedRunners.getFirst();
                umPlayer.setPlayerToTrack(0, trackedPlayer).sendUpdateFromServerToSelf((Player)player);
            }
        }, (player, umPlayer) -> {
            this.spectators.add((Player)player);
            if (player.level().isClientSide) {
                return;
            }
            UMPackets.sendToPlayer(new HunterReleaseAnnounceS2CPacket(false), player);
        }, (player, umPlayer) -> {});
    }

    public List<Player> getHunters() {
        return new ArrayList<Player>(this.hunters);
    }

    public List<Player> getSpeedRunners() {
        return new ArrayList<Player>(this.speedRunners);
    }

    public List<Player> getSpectators() {
        return new ArrayList<Player>(this.spectators);
    }
}

