/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.api.event;

import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.laserdiamond.laserutils.util.raycast.ServerRayCast;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public interface PlayerGameSpawner {
    default public void spawn(Player player) {
        Level level = player.level();
        if (!level.isClientSide) {
            int xSpawn = UMGame.getXSpawnCoordinate();
            int zSpawn = UMGame.getZSpawnCoordinate();
            MinecraftServer mcServer = player.getServer();
            if (mcServer == null) {
                return;
            }
            ServerLevel overworld = this.moveToOverworld(player, mcServer);
            int yMax = overworld.getMaxBuildHeight() + 2;
            int yMin = overworld.getMinBuildHeight();
            EnumSet<RelativeMovement> relativeMovements = EnumSet.noneOf(RelativeMovement.class);
            ServerRayCast src = ServerRayCast.create((ServerLevel)overworld, (Vec3)new Vec3((double)xSpawn, (double)yMax, (double)zSpawn), (Predicate)Predicates.alwaysFalse(), Player.class, List.of());
            src.setCanPierceEntities().setStepIncrement(1.0).fireAtVec3D(new Vec3((double)xSpawn, (double)yMin, (double)zSpawn), 0.0);
            Vec3 lastPos = src.getCurrentPosition();
            player.teleportTo(overworld, lastPos.x, lastPos.y + 1.0, lastPos.z, relativeMovements, player.getYRot(), player.getXRot());
            if (!player.isCreative() && !player.isSpectator()) {
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
                player.onUpdateAbilities();
            }
        }
    }

    default public ServerLevel moveToOverworld(Player player, MinecraftServer mcServer) {
        ServerLevel overworld = mcServer.overworld();
        DimensionTransition transition = new DimensionTransition(overworld, (Entity)player, pEntity -> {});
        player.changeDimension(transition);
        return overworld;
    }
}

