/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.api.event;

import javax.annotation.Nullable;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.api.event.SpeedRunnerToHunterEvent;
import net.laserdiamond.ultimatemanhunt.api.event.SpeedRunnerToSpectatorEvent;
import net.laserdiamond.ultimatemanhunt.api.event.UltimateManhuntGameStateEvent;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.sound.UMSoundEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;

public class SpeedRunnerLifeLossEvent
extends PlayerEvent {
    private final boolean wasKilledByHunter;
    private final Player hunter;

    public SpeedRunnerLifeLossEvent(Player speedRunner, Player hunter) {
        super(speedRunner);
        this.hunter = hunter;
        boolean bl = this.wasKilledByHunter = this.hunter != null;
        if (speedRunner.level().isClientSide) {
            return;
        }
        MinecraftServer server = speedRunner.getServer();
        if (server == null) {
            return;
        }
        speedRunner.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
            umPlayer.subtractLife().setWasLastKilledByHunter(this.wasKilledByHunter).sendUpdateFromServerToSelf(speedRunner);
            if (this.wasKilledByHunter) {
                UMSoundEvents.playFlatlineSound(speedRunner);
                speedRunner.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "You were killed by a Hunter and lost a life!")));
                UMGame.sendMessageToAllPlayers(server, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + speedRunner.getDisplayName().getString() + " was killed by " + hunter.getDisplayName().getString() + " and lost a life!")));
            } else {
                speedRunner.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "You died and lost a life!")));
                UMGame.sendMessageToAllPlayers(server, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + speedRunner.getDisplayName().getString() + " died and lost a life!")));
            }
            if (umPlayer.getLives() <= 0) {
                if (UMGame.getDeadSpeedRunnerRole() == UMGame.PlayerRole.HUNTER) {
                    MinecraftForge.EVENT_BUS.post((Event)new SpeedRunnerToHunterEvent(speedRunner, UMPlayer.getIsBuffedHunterOnFinalDeath(), true));
                    UMGame.sendMessageToAllPlayers(server, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + speedRunner.getDisplayName().getString() + " lost all their lives and is now a hunter!")));
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new SpeedRunnerToSpectatorEvent(speedRunner, this.wasKilledByHunter));
                    UMGame.sendMessageToAllPlayers(server, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + speedRunner.getDisplayName().getString() + " lost all their lives is now a spectator!")));
                }
                if (UMPlayer.getRemainingSpeedRunners().isEmpty()) {
                    MinecraftForge.EVENT_BUS.post((Event)new UltimateManhuntGameStateEvent.End(UltimateManhuntGameStateEvent.End.Reason.HUNTER_WIN));
                }
            }
        });
    }

    public boolean isWasKilledByHunter() {
        return this.wasKilledByHunter;
    }

    @Nullable
    public Player getHunter() {
        return this.hunter;
    }
}

