/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.api.event;

import java.util.LinkedList;
import java.util.List;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.api.event.PlayerGameSpawner;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.item.UMItems;
import net.laserdiamond.ultimatemanhunt.item.WindTorchItem;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.game.GameTimeS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.RemainingPlayerCountS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GameEndAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GamePausedAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GameResumedS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GameStartAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerDistanceFromHunterS2CPacket;
import net.laserdiamond.ultimatemanhunt.sound.UMSoundEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.eventbus.api.Event;

public abstract class UltimateManhuntGameStateEvent
extends Event {
    protected final List<Player> hunters = new LinkedList<Player>();
    protected final List<Player> speedRunners = new LinkedList<Player>();
    protected final List<Player> spectators = new LinkedList<Player>();

    public UltimateManhuntGameStateEvent() {
        UMPlayer.forAllPlayers((player, umPlayer) -> {
            this.speedRunners.add((Player)player);
            this.forSpeedRunner((Player)player, (UMPlayer)((Object)umPlayer));
        }, (player, umPlayer) -> {
            this.hunters.add((Player)player);
            this.forHunter((Player)player, (UMPlayer)((Object)umPlayer));
        }, (player, umPlayer) -> {
            this.spectators.add((Player)player);
            this.forSpectators((Player)player, (UMPlayer)((Object)umPlayer));
        }, this::forAllPlayers);
        UMGame.setCurrentGameState(this.gameState());
    }

    public abstract UMGame.State gameState();

    public List<Player> getHunters() {
        return this.hunters;
    }

    public List<Player> getSpeedRunners() {
        return this.speedRunners;
    }

    public final long getGameTime() {
        return UMGame.getCurrentGameTime();
    }

    protected void forAllPlayers(Player player, UMPlayer umPlayer) {
    }

    protected void forSpeedRunner(Player player, UMPlayer umPlayer) {
    }

    protected void forHunter(Player player, UMPlayer umPlayer) {
    }

    protected void forSpectators(Player player, UMPlayer umPlayer) {
    }

    public static class Resume
    extends UltimateManhuntGameStateEvent {
        public Resume() {
            UMPackets.sendToAllClients(new GameResumedS2CPacket());
            UMPackets.sendToAllClients(new RemainingPlayerCountS2CPacket());
            SpeedRunnerDistanceFromHunterS2CPacket.sendNotNearHunterAll();
        }

        @Override
        public UMGame.State gameState() {
            return UMGame.State.IN_PROGRESS;
        }

        @Override
        protected void forSpeedRunner(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide && !UMGame.containsLoggedPlayerUUID(player)) {
                UMGame.logPlayerUUID(player);
            }
        }

        @Override
        protected void forHunter(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide) {
                if (!UMGame.containsLoggedPlayerUUID(player)) {
                    UMGame.logPlayerUUID(player);
                }
                if (umPlayer.isBuffedHunter()) {
                    player.getAttributes().addTransientAttributeModifiers(UMPlayer.createHunterAttributes());
                }
            }
        }
    }

    public static class Pause
    extends UltimateManhuntGameStateEvent {
        public Pause() {
            UMPackets.sendToAllClients(new GamePausedAnnounceS2CPacket());
            SpeedRunnerDistanceFromHunterS2CPacket.sendNotNearHunterAll();
        }

        @Override
        public UMGame.State gameState() {
            return UMGame.State.PAUSED;
        }

        @Override
        protected void forHunter(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide && umPlayer.isBuffedHunter()) {
                player.getAttributes().removeAttributeModifiers(UMPlayer.createHunterAttributes());
            }
        }
    }

    public static class End
    extends UltimateManhuntGameStateEvent
    implements PlayerGameSpawner {
        private final Reason reason;

        public End(Reason reason) {
            this.reason = reason;
            UMPackets.sendToAllClients(new GameEndAnnounceS2CPacket(this.reason));
            UMPackets.sendToAllClients(new GameTimeS2CPacket(0L));
            UMGame.wipeLoggedPlayerUUIDs();
        }

        public Reason getReason() {
            return this.reason;
        }

        @Override
        public UMGame.State gameState() {
            return UMGame.State.NOT_STARTED;
        }

        @Override
        protected void forAllPlayers(Player player, UMPlayer umPlayer) {
            UMSoundEvents.stopDetectionSound(player);
        }

        @Override
        protected void forSpeedRunner(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide) {
                umPlayer.resetToSpeedRunner(player, false);
                player.getInventory().clearOrCountMatchingItems(itemStack -> itemStack.getItem() instanceof WindTorchItem, -1, (Container)player.inventoryMenu.getCraftSlots());
            }
        }

        @Override
        protected void forHunter(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide) {
                if (umPlayer.isBuffedHunter()) {
                    player.getAttributes().removeAttributeModifiers(UMPlayer.createHunterAttributes());
                }
                umPlayer.resetToSpeedRunner(player, false);
                if (this.getGameTime() < (long)UMGame.getHunterGracePeriod()) {
                    this.spawn(player);
                }
                player.getAbilities().mayfly = player.isCreative() || player.isSpectator();
                player.getAbilities().flying = (player.isCreative() || player.isSpectator()) && player.getAbilities().flying;
                player.onUpdateAbilities();
                player.getInventory().clearOrCountMatchingItems(itemStack -> itemStack.getItem() instanceof WindTorchItem, -1, (Container)player.inventoryMenu.getCraftSlots());
            }
        }

        public static enum Reason {
            HUNTER_WIN,
            SPEED_RUNNERS_WIN,
            COMMAND;


            public static Reason fromOrdinal(int value) {
                for (Reason reason : Reason.values()) {
                    if (reason.ordinal() != value) continue;
                    return reason;
                }
                return null;
            }
        }
    }

    public static class Start
    extends UltimateManhuntGameStateEvent
    implements PlayerGameSpawner {
        public Start() {
            UMGame.resetGameTime();
            UMPackets.sendToAllClients(new RemainingPlayerCountS2CPacket());
            UMPackets.sendToAllClients(new GameStartAnnounceS2CPacket());
            SpeedRunnerDistanceFromHunterS2CPacket.sendNotNearHunterAll();
        }

        @Override
        public UMGame.State gameState() {
            return UMGame.State.STARTED;
        }

        @Override
        protected void forAllPlayers(Player player, UMPlayer umPlayer) {
            player.setHealth(player.getMaxHealth());
            player.tickCount = 0;
            player.getFoodData().eat(200, 1.0f);
            player.getInventory().clearContent();
            if (player.isSpectator()) {
                umPlayer.setRole(UMGame.PlayerRole.SPECTATOR);
            }
            if (!umPlayer.isSpectator() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.setGameMode(GameType.DEFAULT_MODE);
            }
        }

        @Override
        protected void forSpeedRunner(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide) {
                if (UMGame.isWindTorchEnabled()) {
                    player.setItemSlot(EquipmentSlot.MAINHAND, ((Item)UMItems.WIND_TORCH.get()).getDefaultInstance());
                }
                umPlayer.resetToSpeedRunner(player, true);
                this.spawn(player);
            }
        }

        @Override
        protected void forHunter(Player player, UMPlayer umPlayer) {
            if (!player.level().isClientSide) {
                MinecraftServer mcServer;
                umPlayer.resetToHunter(player, true);
                player.getAbilities().mayfly = true;
                player.getAbilities().flying = true;
                player.onUpdateAbilities();
                if (umPlayer.isBuffedHunter()) {
                    player.getAttributes().addTransientAttributeModifiers(UMPlayer.createHunterAttributes());
                    player.setHealth(player.getMaxHealth());
                }
                if ((mcServer = player.getServer()) != null) {
                    this.moveToOverworld(player, player.getServer());
                }
            }
        }
    }
}

