/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.capability;

import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.laserdiamond.laserutils.capability.AbstractCapabilityData;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.UltimateManhunt;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameTime;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.UMCapabilitySyncS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerMaxLifeChangeS2CPacket;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.server.ServerLifecycleHooks;

@AutoRegisterCapability
public class UMPlayer
extends AbstractCapabilityData<UMPlayer> {
    private static final ResourceLocation ACTIVE_MODIFIER = UltimateManhunt.fromUMPath("attribute.active_hunter");
    public static final int MIN_LIVES = 0;
    public static final int MAX_LIVES = 99;
    private static int currentMaxLives = 3;
    private static boolean buffedHunterOnFinalDeath = false;
    private int lives = UMPlayer.getMaxLives();
    private boolean wasLastKilledByHunter = false;
    private long gracePeriodTimeStamp = 0L;
    private boolean isBuffedHunter = false;
    private int trackingIndex = -1;
    private UUID trackingPlayerUUID;
    private UMGame.PlayerRole role;

    public static int getMaxLives() {
        return currentMaxLives;
    }

    public static boolean setMaxLives(int lives) {
        if (UMGame.State.hasGameBeenStarted()) {
            return false;
        }
        currentMaxLives = Math.min(99, Math.max(lives, 1));
        UMPackets.sendToAllClients(new SpeedRunnerMaxLifeChangeS2CPacket(lives));
        return true;
    }

    public static boolean getIsBuffedHunterOnFinalDeath() {
        return buffedHunterOnFinalDeath;
    }

    public static boolean setIsBuffedHunterOnFinalDeath(boolean isBuffedHunter) {
        if (UMGame.State.hasGameBeenStarted()) {
            return false;
        }
        buffedHunterOnFinalDeath = isBuffedHunter;
        return true;
    }

    public static HashMultimap<Holder<Attribute>, AttributeModifier> createHunterAttributes() {
        HashMultimap ret = HashMultimap.create();
        ret.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ret.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ACTIVE_MODIFIER, 5.0, AttributeModifier.Operation.ADD_VALUE));
        ret.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ret.put((Object)Attributes.MOVEMENT_EFFICIENCY, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ret.put((Object)Attributes.WATER_MOVEMENT_EFFICIENCY, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ret.put((Object)Attributes.MINING_EFFICIENCY, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ret.put((Object)Attributes.SUBMERGED_MINING_SPEED, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        ret.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ACTIVE_MODIFIER, 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return ret;
    }

    public static List<Player> getRemainingSpeedRunners() {
        LinkedList<Player> ret = new LinkedList<Player>();
        for (Player player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                if (umPlayer.isSpeedRunner()) {
                    ret.add(player);
                }
            });
        }
        return ret;
    }

    public static boolean isSpeedRunnerOnGracePeriodServer(Player player) {
        AtomicBoolean ret = new AtomicBoolean();
        player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> ret.set(umPlayer.isSpeedRunnerOnGracePeriodServer()));
        return ret.get();
    }

    public static List<Player> getHunters(boolean onlyBuffed) {
        LinkedList<Player> ret = new LinkedList<Player>();
        for (Player player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                if (onlyBuffed && umPlayer.isBuffedHunter()) {
                    ret.add(player);
                } else if (!onlyBuffed && umPlayer.isHunter()) {
                    ret.add(player);
                }
            });
        }
        return ret;
    }

    public static List<Player> getAvailableSpeedRunners(Player playerHunter) {
        LinkedList<Player> ret = new LinkedList<Player>(UMPlayer.getRemainingSpeedRunners());
        Level hunterLvl = playerHunter.level();
        Iterator speedRunnerIterator = ret.iterator();
        while (speedRunnerIterator.hasNext()) {
            Player player = (Player)speedRunnerIterator.next();
            Level speedRunnerLvl = player.level();
            if (playerHunter.getUUID() == player.getUUID()) {
                speedRunnerIterator.remove();
                continue;
            }
            if (hunterLvl.isClientSide || speedRunnerLvl.isClientSide || hunterLvl.dimension().equals((Object)speedRunnerLvl.dimension())) continue;
            speedRunnerIterator.remove();
        }
        return ret;
    }

    public static List<Player> getSpectators() {
        LinkedList<Player> ret = new LinkedList<Player>();
        for (Player player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                if (umPlayer.isSpectator()) {
                    ret.add(player);
                }
            });
        }
        return ret;
    }

    public static void forAllPlayers(BiConsumer<Player, UMPlayer> forSpeedRunners, BiConsumer<Player, UMPlayer> forHunters, BiConsumer<Player, UMPlayer> forSpectators, BiConsumer<Player, UMPlayer> forAll) {
        for (Player player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                forAll.accept(player, (UMPlayer)((Object)umPlayer));
                if (umPlayer.isSpeedRunner()) {
                    forSpeedRunners.accept(player, (UMPlayer)((Object)umPlayer));
                } else if (umPlayer.isHunter()) {
                    forHunters.accept(player, (UMPlayer)((Object)umPlayer));
                } else if (umPlayer.isSpectator()) {
                    forSpectators.accept(player, (UMPlayer)((Object)umPlayer));
                } else {
                    forSpectators.accept(player, (UMPlayer)((Object)umPlayer));
                }
            });
        }
    }

    public UMPlayer(UUID defaultTrackingUUID) {
        this.trackingPlayerUUID = defaultTrackingUUID;
        this.role = UMGame.PlayerRole.SPEED_RUNNER;
    }

    public void copyFrom(UMPlayer umPlayer) {
        this.lives = umPlayer.lives;
        this.wasLastKilledByHunter = umPlayer.wasLastKilledByHunter;
        this.gracePeriodTimeStamp = umPlayer.gracePeriodTimeStamp;
        this.isBuffedHunter = umPlayer.isBuffedHunter;
        this.trackingIndex = umPlayer.trackingIndex;
        this.trackingPlayerUUID = umPlayer.trackingPlayerUUID;
        this.role = umPlayer.role;
    }

    public void saveNBTData(CompoundTag compoundTag) {
        compoundTag.putInt("speed_runner_lives", this.getLives());
        compoundTag.putBoolean("was_last_killed_by_hunter", this.isWasLastKilledByHunter());
        compoundTag.putLong("grace_period_time_stamp", this.getGracePeriodTimeStamp());
        compoundTag.putBoolean("is_buffed_hunter", this.isBuffedHunter());
        compoundTag.putInt("tracking_index", this.getTrackingIndex());
        compoundTag.putUUID("tracking_player_uuid", this.getTrackingPlayerUUID());
        compoundTag.putString("role", this.getRole().toString());
    }

    public void loadNBTData(CompoundTag compoundTag) {
        this.lives = compoundTag.getInt("speed_runner_lives");
        this.wasLastKilledByHunter = compoundTag.getBoolean("was_last_killed_by_hunter");
        this.gracePeriodTimeStamp = compoundTag.getLong("grace_period_time_stamp");
        this.isBuffedHunter = compoundTag.getBoolean("is_buffed_hunter");
        this.trackingIndex = compoundTag.getInt("tracking_player_index");
        this.trackingPlayerUUID = compoundTag.getUUID("tracking_player_uuid");
        this.role = UMGame.PlayerRole.fromString(compoundTag.getString("role"));
    }

    public int getLives() {
        return this.lives;
    }

    public UMPlayer setLives(int lives) {
        this.lives = Math.max(0, Math.min(lives, UMPlayer.getMaxLives()));
        return this;
    }

    public UMPlayer subtractLife() {
        this.setLives(this.getLives() - 1);
        return this;
    }

    public boolean isWasLastKilledByHunter() {
        return this.wasLastKilledByHunter;
    }

    public UMPlayer setWasLastKilledByHunter(boolean wasLastKilledByHunter) {
        this.wasLastKilledByHunter = wasLastKilledByHunter;
        return this;
    }

    public long getGracePeriodTimeStamp() {
        return this.gracePeriodTimeStamp;
    }

    public UMPlayer setGracePeriodTimeStamp(long gracePeriodTimeStamp) {
        this.gracePeriodTimeStamp = Math.max(0L, gracePeriodTimeStamp);
        return this;
    }

    private boolean getIsBuffedHunter() {
        return this.isBuffedHunter;
    }

    public UMPlayer setBuffedHunter(boolean buffedHunter) {
        this.isBuffedHunter = buffedHunter;
        return this;
    }

    public int getTrackingIndex() {
        return this.trackingIndex;
    }

    private UMPlayer setTrackingIndex(int trackingIndex) {
        this.trackingIndex = trackingIndex;
        return this;
    }

    private void setPlayerToTrack(Player player) {
        this.trackingPlayerUUID = player.getUUID();
    }

    public UMPlayer setPlayerToTrack(int trackingIndex, Player player) {
        this.setTrackingIndex(trackingIndex);
        this.setPlayerToTrack(player);
        return this;
    }

    public UUID getTrackingPlayerUUID() {
        return this.trackingPlayerUUID;
    }

    public UMGame.PlayerRole getRole() {
        return this.role;
    }

    public UMPlayer setRole(UMGame.PlayerRole role) {
        this.role = role;
        return this;
    }

    public boolean isSpeedRunner() {
        return this.getLives() > 0 && this.getRole() == UMGame.PlayerRole.SPEED_RUNNER;
    }

    public boolean isHunter() {
        return this.getRole() == UMGame.PlayerRole.HUNTER;
    }

    public boolean isBuffedHunter() {
        return this.isHunter() && this.isBuffedHunter;
    }

    public boolean isSpectator() {
        return this.getRole() == UMGame.PlayerRole.SPECTATOR;
    }

    public boolean isSpeedRunnerOnGracePeriodServer() {
        return this.isSpeedRunner() && UMGame.getCurrentGameTime() < this.getGracePeriodTimeStamp();
    }

    public boolean isSpeedRunnerOnGracePeriodClient() {
        return this.isSpeedRunner() && ClientGameTime.getGameTime() < this.getGracePeriodTimeStamp();
    }

    public void reset(Player player, UMGame.PlayerRole role, boolean logPlayer) {
        if (logPlayer) {
            UMGame.logPlayerUUID(player);
        }
        this.setRole(role).setLives(UMPlayer.getMaxLives()).setWasLastKilledByHunter(false).setGracePeriodTimeStamp(0L).sendUpdateFromServerToSelf(player);
    }

    public void resetToSpeedRunner(Player player, boolean logPlayer) {
        this.setBuffedHunter(false);
        this.reset(player, UMGame.PlayerRole.SPEED_RUNNER, logPlayer);
    }

    public void resetToHunter(Player player, boolean logPlayer) {
        UMGame.logPlayerUUID(player);
        this.reset(player, UMGame.PlayerRole.HUNTER, logPlayer);
    }

    public void resetToSpectator(Player player, boolean logPlayer) {
        this.reset(player, UMGame.PlayerRole.SPECTATOR, logPlayer);
    }

    public final void sendUpdateFromServer(Player trackedPlayer, Player receivingPlayer) {
        UMPackets.sendToAllTrackingEntity(new UMCapabilitySyncS2CPacket((Entity)trackedPlayer, this), (Entity)receivingPlayer);
    }

    public final void sendUpdateFromServerToSelf(Player player) {
        UMPackets.sendToAllTrackingEntityAndSelf(new UMCapabilitySyncS2CPacket((Entity)player, this), (Entity)player);
    }
}

