/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.laserdiamond.laserutils.util.registry.LanguageRegistry;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameState;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.ChangeTrackingSpeedRunnerC2SPacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ultimate_manhunt", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class UMKeyBindings {
    public static final UMKeyBindings INSTANCE = new UMKeyBindings();
    private static final String DESCRIPTION_PREFIX = "key.ultimate_manhunt.";
    public static final String CATEGORY = "key.categories.ultimate_manhunt";
    public final KeyMapping cycleRight = UMKeyBindings.registerKeyMapping("Track Next Speed Runner", "cycle_right_speed_runner", KeyConflictContext.IN_GAME, 262);
    public final KeyMapping cycleLeft = UMKeyBindings.registerKeyMapping("Track Previous Speed Runner", "cycle_left_speed_runner", KeyConflictContext.IN_GAME, 263);

    private UMKeyBindings() {
    }

    public static KeyMapping registerKeyMapping(String name, String description, KeyConflictContext keyConflictContext, int keyInputConstant) {
        KeyMapping keyMapping = new KeyMapping(DESCRIPTION_PREFIX + description, (IKeyConflictContext)keyConflictContext, InputConstants.getKey((int)keyInputConstant, (int)-1), CATEGORY);
        LanguageRegistry.instance((String)"ultimate_manhunt", (LanguageRegistry.LanguageType)LanguageRegistry.Language.EN_US).keyMappingNameRegistry.addEntry((Object)keyMapping, (Object)name);
        return keyMapping;
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(UMKeyBindings.INSTANCE.cycleRight);
        event.register(UMKeyBindings.INSTANCE.cycleLeft);
    }

    public static enum TrackCycleDirection {
        NEXT,
        PREVIOUS;

    }

    @Mod.EventBusSubscriber(modid="ultimate_manhunt", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class KeyInputEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer localPlayer = minecraft.player;
            if (localPlayer == null) {
                return;
            }
            if (!ClientGameState.hasGameBeenStarted()) {
                return;
            }
            localPlayer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                if (umPlayer.isHunter()) {
                    if (UMKeyBindings.INSTANCE.cycleRight.consumeClick()) {
                        UMPackets.sendToServer(new ChangeTrackingSpeedRunnerC2SPacket(TrackCycleDirection.NEXT));
                    } else if (UMKeyBindings.INSTANCE.cycleLeft.consumeClick()) {
                        UMPackets.sendToServer(new ChangeTrackingSpeedRunnerC2SPacket(TrackCycleDirection.PREVIOUS));
                    }
                }
            });
        }
    }
}

