/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.client.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DecimalFormat;
import java.util.UUID;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameState;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameTime;
import net.laserdiamond.ultimatemanhunt.client.hud.UMHUDOverlay;
import net.laserdiamond.ultimatemanhunt.client.hunter.ClientHunterGracePeriod;
import net.laserdiamond.ultimatemanhunt.client.hunter.ClientTrackedSpeedRunner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public final class HunterTrackerOverlay
implements UMHUDOverlay {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();

    @Override
    public void onRender(LocalPlayer player, UMPlayer umPlayer, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int drawX = guiGraphics.guiWidth() / 2;
        int drawY = guiGraphics.guiHeight() - 77;
        boolean areSpeedRunnersPresent = ClientTrackedSpeedRunner.areSpeedRunnersPresent();
        float distance = ClientTrackedSpeedRunner.getDistance();
        String trackedPlayerName = ClientTrackedSpeedRunner.getTrackedPlayerName();
        UUID trackedUUID = ClientTrackedSpeedRunner.getTrackedPlayerUUID();
        long gameTime = ClientGameTime.getGameTime();
        Camera camera = HunterTrackerOverlay.MINECRAFT.gameRenderer.getMainCamera();
        DecimalFormat format = new DecimalFormat("0.00");
        if (!umPlayer.isHunter()) {
            return;
        }
        if (gameTime >= (long)ClientHunterGracePeriod.getGracePeriodDuration()) {
            if (areSpeedRunnersPresent) {
                if (trackedUUID != player.getUUID()) {
                    guiGraphics.drawCenteredString(HunterTrackerOverlay.MINECRAFT.font, (Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + trackedPlayerName + " is " + String.valueOf(ChatFormatting.YELLOW) + format.format(distance) + String.valueOf(ChatFormatting.GREEN) + " blocks away")), drawX, drawY, ChatFormatting.GREEN.getColor().intValue());
                    Vec3 speedRunnerPos = ClientTrackedSpeedRunner.getPosition();
                    Vec3 hunterCameraPos = camera.getPosition();
                    double cameraDistanceToPlayer = hunterCameraPos.distanceTo(speedRunnerPos);
                    double xDif = hunterCameraPos.x - speedRunnerPos.x;
                    double yDif = hunterCameraPos.y - speedRunnerPos.y;
                    double zDif = hunterCameraPos.z - speedRunnerPos.z;
                    double yRot = Math.acos(yDif / cameraDistanceToPlayer) + 4.71238898038469;
                    double xRotTan = Math.atan2(zDif, -xDif) + Math.PI;
                    Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
                    matrix4fstack.pushMatrix();
                    matrix4fstack.mul((Matrix4fc)guiGraphics.pose().last().pose());
                    matrix4fstack.translate((float)(guiGraphics.guiWidth() / 2), (float)(guiGraphics.guiHeight() / 2), 0.0f);
                    matrix4fstack.rotateX((float)((double)(-camera.getXRot() * ((float)Math.PI / 180)) - yRot));
                    matrix4fstack.rotateY((float)((double)((45.0f + camera.getYRot()) * ((float)Math.PI / 180)) + xRotTan));
                    matrix4fstack.scale(-1.0f, -1.0f, -1.0f);
                    RenderSystem.applyModelViewMatrix();
                    this.renderTrackerLines(30, -16777216, -16711936, true, true);
                    matrix4fstack.rotateY(0.7853982f);
                    matrix4fstack.rotateZ(1.5707964f);
                    RenderSystem.applyModelViewMatrix();
                    this.renderTrackerLines(50, -16777216, -65536, false, true);
                    matrix4fstack.popMatrix();
                    RenderSystem.applyModelViewMatrix();
                } else {
                    guiGraphics.drawCenteredString(HunterTrackerOverlay.MINECRAFT.font, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "This Speed Runner cannot be tracked from your current position")), drawX, drawY, ChatFormatting.RED.getColor().intValue());
                }
            } else {
                guiGraphics.drawCenteredString(HunterTrackerOverlay.MINECRAFT.font, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "This Speed Runner cannot be tracked from your current position")), drawX, drawY, ChatFormatting.RED.getColor().intValue());
            }
        }
    }

    private void renderTrackerLines(int lineLength, int outerColor, int innerColor, boolean drawX, boolean drawZ) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        RenderSystem.lineWidth((float)4.0f);
        if (drawX) {
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f).setColor(outerColor).setNormal(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex((float)lineLength, 0.0f, 0.0f).setColor(outerColor).setNormal(1.0f, 0.0f, 0.0f);
        }
        if (drawZ) {
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f).setColor(outerColor).setNormal(0.0f, 0.0f, 1.0f);
            bufferbuilder.addVertex(0.0f, 0.0f, (float)lineLength).setColor(outerColor).setNormal(0.0f, 0.0f, 1.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.lineWidth((float)2.0f);
        bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        if (drawX) {
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f).setColor(innerColor).setNormal(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex((float)lineLength, 0.0f, 0.0f).setColor(innerColor).setNormal(1.0f, 0.0f, 0.0f);
        }
        if (drawZ) {
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f).setColor(innerColor).setNormal(0.0f, 0.0f, 1.0f);
            bufferbuilder.addVertex(0.0f, 0.0f, (float)lineLength).setColor(innerColor).setNormal(0.0f, 0.0f, 1.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.lineWidth((float)1.0f);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
    }

    @Override
    public boolean renderIfGameNotStarted() {
        return ClientGameState.isGameRunning();
    }
}

