/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.client.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameState;
import net.laserdiamond.ultimatemanhunt.client.hud.UMHUDOverlay;
import net.laserdiamond.ultimatemanhunt.client.speedrunner.ClientDistanceFromHunter;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;

public final class SpeedRunnerHunterDetectionOverlay
implements UMHUDOverlay {
    @Override
    public void onRender(LocalPlayer player, UMPlayer umPlayer, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        float distanceFromHunter = ClientDistanceFromHunter.getDistance();
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        if (umPlayer.isSpeedRunner() && distanceFromHunter > -1.0f && distanceFromHunter < 50.0f && !umPlayer.isSpeedRunnerOnGracePeriodClient()) {
            float red = -(distanceFromHunter / 110.0f) + 0.9f;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            guiGraphics.setColor(red, 0.1f, 0.1f, 1.0f);
            guiGraphics.blit(GameRenderer.NAUSEA_LOCATION, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public boolean renderIfGameNotStarted() {
        return ClientGameState.isGameRunning();
    }
}

