/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.client.hud;

import java.text.DecimalFormat;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameTime;
import net.laserdiamond.ultimatemanhunt.client.game.ClientHardcore;
import net.laserdiamond.ultimatemanhunt.client.hud.UMHUDOverlay;
import net.laserdiamond.ultimatemanhunt.client.speedrunner.ClientSpeedRunnerMaxLives;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class SpeedRunnerLivesOverlay
implements UMHUDOverlay {
    private static final ResourceLocation SPEED_RUNNER_EMPTY_HEART_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/heart/container_hardcore");
    private static final ResourceLocation SPEED_RUNNER_FULL_HEART_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/heart/full");
    private static final ResourceLocation SPEED_RUNNER_FULL_HEART_HARDCORE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_full");

    @Override
    public void onRender(LocalPlayer player, UMPlayer umPlayer, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int lives = umPlayer.getLives();
        boolean isSpeedRunner = umPlayer.isSpeedRunner();
        long gameTime = ClientGameTime.getGameTime();
        if (isSpeedRunner) {
            int drawX = guiGraphics.guiWidth() / 2 - 104;
            int drawY = guiGraphics.guiHeight() - 39;
            if (ClientSpeedRunnerMaxLives.getMaxLives() <= 5) {
                for (int i = 0; i < ClientSpeedRunnerMaxLives.getMaxLives(); ++i) {
                    guiGraphics.blitSprite(SPEED_RUNNER_EMPTY_HEART_TEXTURE, drawX, drawY - i * 10, 9, 9);
                    if (i >= lives) continue;
                    if (ClientHardcore.isHardcore()) {
                        guiGraphics.blitSprite(SPEED_RUNNER_FULL_HEART_HARDCORE_TEXTURE, drawX, drawY - i * 10, 9, 9);
                        continue;
                    }
                    guiGraphics.blitSprite(SPEED_RUNNER_FULL_HEART_TEXTURE, drawX, drawY - i * 10, 9, 9);
                }
            } else {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.literal((String)("x" + umPlayer.getLives())), drawX, drawY, ChatFormatting.WHITE.getColor().intValue());
                guiGraphics.blitSprite(SPEED_RUNNER_EMPTY_HEART_TEXTURE, drawX -= 20, drawY, 9, 9);
                if (ClientHardcore.isHardcore()) {
                    guiGraphics.blitSprite(SPEED_RUNNER_FULL_HEART_HARDCORE_TEXTURE, drawX, drawY, 9, 9);
                } else {
                    guiGraphics.blitSprite(SPEED_RUNNER_FULL_HEART_TEXTURE, drawX, drawY, 9, 9);
                }
            }
            Component speedRunnerGracePeriodComponent = this.getSpeedRunnerGracePeriodComponent(gameTime, umPlayer.getGracePeriodTimeStamp());
            drawX = guiGraphics.guiWidth() / 2;
            double diff = (double)guiGraphics.guiHeight() * 0.95678;
            drawY = (int)((double)guiGraphics.guiHeight() - diff);
            if (!speedRunnerGracePeriodComponent.getString().isEmpty()) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, speedRunnerGracePeriodComponent, drawX, drawY, ChatFormatting.BLUE.getColor().intValue());
            }
        }
    }

    @NotNull
    private Component getSpeedRunnerGracePeriodComponent(long gameTime, long gracePeriodTimeStamp) {
        double seconds = (double)(gracePeriodTimeStamp - gameTime) / 20.0;
        DecimalFormat format = new DecimalFormat("0.00");
        if (seconds >= 0.0) {
            return Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + String.valueOf(ChatFormatting.BOLD) + "You are protected from hunters for " + String.valueOf(ChatFormatting.YELLOW) + format.format(seconds) + String.valueOf(ChatFormatting.BLUE) + String.valueOf(ChatFormatting.BOLD) + " seconds"));
        }
        return Component.empty();
    }
}

