/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameState;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;

public interface UMHUDOverlay
extends LayeredDraw.Layer {
    default public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (this.shouldNotRenderInSpectator(player)) {
            return;
        }
        if (!this.renderIfGameNotStarted()) {
            return;
        }
        RenderSystem.enableBlend();
        this.setUpRender();
        player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> this.onRender(player, (UMPlayer)((Object)umPlayer), guiGraphics, deltaTracker));
        RenderSystem.disableBlend();
    }

    public void onRender(LocalPlayer var1, UMPlayer var2, GuiGraphics var3, DeltaTracker var4);

    default public boolean shouldNotRenderInSpectator(LocalPlayer player) {
        return player.isSpectator();
    }

    default public boolean renderIfGameNotStarted() {
        return ClientGameState.hasGameBeenStarted();
    }

    default public void setUpRender() {
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

