/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.client.hud;

import java.text.DecimalFormat;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.client.game.ClientGameTime;
import net.laserdiamond.ultimatemanhunt.client.game.ClientRemainingPlayers;
import net.laserdiamond.ultimatemanhunt.client.hud.UMHUDOverlay;
import net.laserdiamond.ultimatemanhunt.client.hunter.ClientHunterGracePeriod;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public final class UpperScreenTextOverlay
implements UMHUDOverlay {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();

    @Override
    public void onRender(LocalPlayer player, UMPlayer umPlayer, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int drawX = guiGraphics.guiWidth() / 2;
        double diff = (double)guiGraphics.guiHeight() * 0.95678;
        int drawY = (int)((double)guiGraphics.guiHeight() - diff);
        long gameTime = ClientGameTime.getGameTime();
        if (gameTime < (long)ClientHunterGracePeriod.getGracePeriodDuration()) {
            Component hunterGracePeriodComponent = this.getHunterGracePeriodComponent(umPlayer.isHunter(), gameTime);
            guiGraphics.drawCenteredString(UpperScreenTextOverlay.MINECRAFT.font, hunterGracePeriodComponent, drawX, drawY, ChatFormatting.RED.getColor().intValue());
        }
        Component remainingHuntersComponent = this.createRemainingPlayersComponent(true);
        Component remainingSpeedRunnersComponent = this.createRemainingPlayersComponent(false);
        guiGraphics.drawCenteredString(UpperScreenTextOverlay.MINECRAFT.font, remainingHuntersComponent, drawX, drawY + 10, ChatFormatting.RED.getColor().intValue());
        guiGraphics.drawCenteredString(UpperScreenTextOverlay.MINECRAFT.font, remainingSpeedRunnersComponent, drawX, drawY + 20, ChatFormatting.BLUE.getColor().intValue());
    }

    @NotNull
    private Component getHunterGracePeriodComponent(boolean isHunter, long gameTime) {
        double seconds = (double)((long)ClientHunterGracePeriod.getGracePeriodDuration() - gameTime) / 20.0;
        DecimalFormat format = new DecimalFormat("0.00");
        if (isHunter) {
            return Component.literal((String)(String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + "You will be released in " + String.valueOf(ChatFormatting.YELLOW) + format.format(seconds) + String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + " seconds"));
        }
        return Component.literal((String)(String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + "Hunters will be released in " + String.valueOf(ChatFormatting.YELLOW) + format.format(seconds) + String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + " seconds"));
    }

    @NotNull
    private Component createRemainingPlayersComponent(boolean isHunters) {
        int speedRunners = ClientRemainingPlayers.getRemainingSpeedRunners();
        int hunters = ClientRemainingPlayers.getRemainingHunters();
        if (isHunters) {
            return Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Remaining Hunters: " + String.valueOf(ChatFormatting.YELLOW) + hunters));
        }
        return Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Remaining Speed Runners: " + String.valueOf(ChatFormatting.YELLOW) + speedRunners));
    }

    @Override
    public boolean shouldNotRenderInSpectator(LocalPlayer player) {
        return false;
    }
}

