/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.laserdiamond.ultimatemanhunt.util.file.UMGameSettingProfileConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class GameProfileSC
extends UltimateManhuntCommands.SubCommand {
    public GameProfileSC(LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)argumentBuilder.then(Commands.literal((String)"gameProfiles").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"game_profile_name", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"load").executes(commandContext -> GameProfileSC.loadGameProfile((CommandContext<CommandSourceStack>)commandContext, StringArgumentType.getString((CommandContext)commandContext, (String)"game_profile_name"))))).then(Commands.literal((String)"save").executes(commandContext -> GameProfileSC.saveGameProfile((CommandContext<CommandSourceStack>)commandContext, StringArgumentType.getString((CommandContext)commandContext, (String)"game_profile_name"))))).then(Commands.literal((String)"delete").executes(commandContext -> GameProfileSC.deleteGameProfile((CommandContext<CommandSourceStack>)commandContext, StringArgumentType.getString((CommandContext)commandContext, (String)"game_profile_name"))))))));
    }

    private static int loadGameProfile(CommandContext<CommandSourceStack> commandContext, String profileName) {
        int i = 0;
        if (UMGame.State.hasGameBeenStarted()) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot load Game Profiles when a game has already been started!")));
            return i;
        }
        if (!UMGameSettingProfileConfig.doesGameProfileFileExist(profileName)) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Game Profile \"" + profileName + "\" does not exist")));
            return i;
        }
        new UMGameSettingProfileConfig(profileName).applySettingsToGame();
        ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("Applied settings from Game Profile \"" + profileName + "\" to game")), true);
        return ++i;
    }

    private static int saveGameProfile(CommandContext<CommandSourceStack> commandContext, String profileName) {
        int i = 0;
        if (UMGameSettingProfileConfig.doesGameProfileFileExist(profileName)) {
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("Overwrote settings for Game Profile \"" + profileName + "\"")), true);
            return ++i;
        }
        new UMGameSettingProfileConfig(profileName).saveSettingsToFile();
        ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("Saved new Game Profile \"" + profileName + "\" to file.")), true);
        return ++i;
    }

    private static int deleteGameProfile(CommandContext<CommandSourceStack> commandContext, String profileName) {
        int i = 0;
        if (!UMGameSettingProfileConfig.doesGameProfileFileExist(profileName)) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Game Profile \"" + profileName + "\" does not exist")));
            return i;
        }
        new UMGameSettingProfileConfig(profileName).deleteFile();
        ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("Deleted Game Profile \"" + profileName + "\"")), true);
        return ++i;
    }
}

