/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.UltimateManhunt;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class GracePeriodSC
extends UltimateManhuntCommands.SubCommand {
    public GracePeriodSC(LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)argumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gracePeriod").requires(UltimateManhunt::hasPermission)).then(Commands.literal((String)"hunter").then(Commands.argument((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(commandContext -> GracePeriodSC.setGracePeriod((CommandContext<CommandSourceStack>)commandContext, Team.HUNTERS, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"durationTicks")))))).then(Commands.literal((String)"speed_runner").then(Commands.argument((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(commandContext -> GracePeriodSC.setGracePeriod((CommandContext<CommandSourceStack>)commandContext, Team.SPEED_RUNNERS, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"durationTicks"))))))));
    }

    private static void logGracePeriodChange(CommandSourceStack source, @NotNull Team team, int newDuration) {
        String teamName = switch (team.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Hunters";
            case 1 -> "Speed Runners";
        };
        source.sendSuccess(() -> Component.literal((String)("Set " + teamName + " grace period to: " + newDuration + " ticks")), true);
    }

    private static void logFailGracePeriodChange(CommandSourceStack source, FailReason reason, int newDuration) {
        switch (reason.ordinal()) {
            case 0: {
                source.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot change the hunter's grace period while the game is active!")));
                break;
            }
            case 1: {
                source.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Hunter grace period must be greater than 0 ticks long. \n Value entered: " + newDuration)));
            }
        }
    }

    private static int setGracePeriod(CommandContext<CommandSourceStack> commandContext, @NotNull Team team, int newDuration) {
        int i = 0;
        if (UMGame.State.hasGameBeenStarted()) {
            GracePeriodSC.logFailGracePeriodChange((CommandSourceStack)commandContext.getSource(), FailReason.GAME_STARTED, newDuration);
            return 0;
        }
        if (newDuration <= 0) {
            GracePeriodSC.logFailGracePeriodChange((CommandSourceStack)commandContext.getSource(), FailReason.INVALID_VALUE, newDuration);
            return 0;
        }
        switch (team.ordinal()) {
            case 0: {
                UMGame.setHunterGracePeriod(newDuration);
                GracePeriodSC.logGracePeriodChange((CommandSourceStack)commandContext.getSource(), team, newDuration);
                break;
            }
            case 1: {
                UMGame.setSpeedRunnerGracePeriod(newDuration);
                GracePeriodSC.logGracePeriodChange((CommandSourceStack)commandContext.getSource(), team, newDuration);
            }
        }
        return i;
    }

    private static enum Team {
        HUNTERS,
        SPEED_RUNNERS;

    }

    private static enum FailReason {
        GAME_STARTED,
        INVALID_VALUE;

    }
}

