/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.api.event.UltimateManhuntGameStateEvent;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.laserdiamond.ultimatemanhunt.util.file.UMGameSettingProfileConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class SetGameStateSC
extends UltimateManhuntCommands.SubCommand {
    public SetGameStateSC(LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)argumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gameState").then(((LiteralArgumentBuilder)Commands.literal((String)"start").executes(commandContext -> SetGameStateSC.changeGameState((CommandContext<CommandSourceStack>)commandContext, UMGame.State.STARTED))).then(Commands.argument((String)"game_profile_name", (ArgumentType)StringArgumentType.string()).executes(commandContext -> SetGameStateSC.startGameFromProfile((CommandContext<CommandSourceStack>)commandContext, StringArgumentType.getString((CommandContext)commandContext, (String)"game_profile_name")))))).then(Commands.literal((String)"pause").executes(commandContext -> SetGameStateSC.changeGameState((CommandContext<CommandSourceStack>)commandContext, UMGame.State.PAUSED)))).then(Commands.literal((String)"resume").executes(commandContext -> SetGameStateSC.changeGameState((CommandContext<CommandSourceStack>)commandContext, UMGame.State.IN_PROGRESS)))).then(Commands.literal((String)"stop").executes(commandContext -> SetGameStateSC.changeGameState((CommandContext<CommandSourceStack>)commandContext, UMGame.State.NOT_STARTED))))));
    }

    private static void logGameStateChange(CommandSourceStack source, UMGame.State newGameState, boolean successful) {
        if (successful) {
            source.sendSuccess(() -> Component.literal((String)("Set the current state of the " + String.valueOf(ChatFormatting.GOLD) + "Ultimate Manhunt Game" + String.valueOf(ChatFormatting.WHITE) + " to " + String.valueOf(ChatFormatting.AQUA) + newGameState.getAsName())), true);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                switch (newGameState) {
                    case STARTED: {
                        player.sendSystemMessage((Component)Component.literal((String)("The " + String.valueOf(ChatFormatting.GOLD) + "Ultimate Manhunt Game" + String.valueOf(ChatFormatting.WHITE) + " has started!")));
                        break;
                    }
                    case IN_PROGRESS: {
                        player.sendSystemMessage((Component)Component.literal((String)("The " + String.valueOf(ChatFormatting.GOLD) + "Ultimate Manhunt Game" + String.valueOf(ChatFormatting.WHITE) + " has resumed!")));
                        break;
                    }
                    case PAUSED: {
                        player.sendSystemMessage((Component)Component.literal((String)("The " + String.valueOf(ChatFormatting.GOLD) + "Ultimate Manhunt Game" + String.valueOf(ChatFormatting.WHITE) + " has been paused!")));
                        break;
                    }
                    case NOT_STARTED: {
                        player.sendSystemMessage((Component)Component.literal((String)("The " + String.valueOf(ChatFormatting.GOLD) + "Ultimate Manhunt Game" + String.valueOf(ChatFormatting.WHITE) + " was forcefully ended!")));
                    }
                }
            }
        } else {
            source.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot change the current state of the " + String.valueOf(ChatFormatting.GOLD) + "Ultimate Manhunt Game" + String.valueOf(ChatFormatting.RED) + " from " + String.valueOf(ChatFormatting.AQUA) + UMGame.getCurrentGameState().getAsName() + String.valueOf(ChatFormatting.RED) + " to " + String.valueOf(ChatFormatting.AQUA) + newGameState.getAsName())));
        }
    }

    private static void logFailStart(CommandSourceStack source, UMGame.State newGameState) {
        switch (newGameState) {
            case STARTED: {
                source.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot start the game because there are no Hunters!")));
                break;
            }
            case IN_PROGRESS: {
                source.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot resume the game because there are no Hunters!")));
            }
        }
    }

    private static int changeGameState(CommandContext<CommandSourceStack> commandContext, UMGame.State newGameState) {
        int i = 0;
        List<Player> hunters = UMPlayer.getHunters(false);
        List<Player> speedRunners = UMPlayer.getRemainingSpeedRunners();
        if (UMGame.setCurrentGameState(newGameState)) {
            switch (newGameState) {
                case STARTED: {
                    MinecraftForge.EVENT_BUS.post((Event)new UltimateManhuntGameStateEvent.Start());
                    break;
                }
                case IN_PROGRESS: {
                    MinecraftForge.EVENT_BUS.post((Event)new UltimateManhuntGameStateEvent.Resume());
                    break;
                }
                case PAUSED: {
                    MinecraftForge.EVENT_BUS.post((Event)new UltimateManhuntGameStateEvent.Pause());
                    break;
                }
                case NOT_STARTED: {
                    MinecraftForge.EVENT_BUS.post((Event)new UltimateManhuntGameStateEvent.End(UltimateManhuntGameStateEvent.End.Reason.COMMAND));
                }
            }
            SetGameStateSC.logGameStateChange((CommandSourceStack)commandContext.getSource(), newGameState, true);
            ++i;
        } else {
            SetGameStateSC.logGameStateChange((CommandSourceStack)commandContext.getSource(), newGameState, false);
        }
        return i;
    }

    private static int startGameFromProfile(CommandContext<CommandSourceStack> commandContext, String profileName) {
        int i = 0;
        if (!UMGameSettingProfileConfig.doesGameProfileFileExist(profileName)) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot start game from Game Profile \"" + profileName + "\" because it does not exist")));
            return i;
        }
        new UMGameSettingProfileConfig(profileName).applySettingsToGame();
        if (UMGame.setCurrentGameState(UMGame.State.STARTED)) {
            MinecraftForge.EVENT_BUS.post((Event)new UltimateManhuntGameStateEvent.Start());
            SetGameStateSC.logGameStateChange((CommandSourceStack)commandContext.getSource(), UMGame.State.STARTED, true);
            ++i;
        }
        return i;
    }
}

