/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.laserdiamond.laserutils.util.raycast.ServerRayCast;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class SetSpawnCommand
extends UltimateManhuntCommands.SubCommand {
    public SetSpawnCommand(LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)argumentBuilder.then(Commands.literal((String)"setSpawn").then(((RequiredArgumentBuilder)Commands.argument((String)"location", (ArgumentType)Vec2Argument.vec2()).executes(commandContext -> SetSpawnCommand.modifySpawn((CommandContext<CommandSourceStack>)commandContext, Vec2Argument.getVec2((CommandContext)commandContext, (String)"location"), true))).then(Commands.argument((String)"moveWorldSpawn", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> SetSpawnCommand.modifySpawn((CommandContext<CommandSourceStack>)commandContext, Vec2Argument.getVec2((CommandContext)commandContext, (String)"location"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"moveWorldSpawn"))))))));
    }

    private static int modifySpawn(CommandContext<CommandSourceStack> commandContext, Vec2 pos, boolean moveWorldSpawn) {
        int i = 0;
        float x = pos.x;
        float z = pos.y;
        ServerLevel sl = ((CommandSourceStack)commandContext.getSource()).getLevel();
        if (sl.dimension() != Level.OVERWORLD) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot set the spawn point of the Ultimate Manhunt game outside of the Overworld!")));
            return i;
        }
        if (UMGame.State.hasGameBeenStarted()) {
            ((CommandSourceStack)commandContext.getSource()).sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot change the Ultimate Manhunt game spawn when a game has already been started!")));
            return i;
        }
        ServerRayCast src = ServerRayCast.create((ServerLevel)sl, (Vec3)new Vec3((double)x, (double)(sl.getMaxBuildHeight() + 2), (double)z), Entity::isAttackable, Player.class, List.of());
        src.setCanPierceEntities().setStepIncrement(1.0).fireAtVec3D(new Vec3((double)x, (double)sl.getMinBuildHeight(), (double)z), 0.0);
        Vec3 lastPos = src.getCurrentPosition();
        UMGame.setXAndZSpawnCoordinate((int)x, (int)z);
        BlockPos spawnPos = new BlockPos((int)lastPos.x, (int)lastPos.y, (int)lastPos.z);
        ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)("Set Ultimate Manhunt spawn to: X:" + spawnPos.getX() + ", Y: " + spawnPos.getY() + ", Z: " + spawnPos.getZ())), true);
        if (moveWorldSpawn) {
            sl.setDefaultSpawnPos(spawnPos, 0.0f);
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.translatable((String)"commands.setworldspawn.success", (Object[])new Object[]{spawnPos.getX(), spawnPos.getY(), spawnPos.getZ(), 0}), true);
        }
        return ++i;
    }
}

