/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.commands.sub.lives;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class SetCurrentLivesSC
extends UltimateManhuntCommands.SubCommand {
    public SetCurrentLivesSC(LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)argumentBuilder.then(Commands.literal((String)"lives").then(Commands.literal((String)"setCurrent").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"add").then(Commands.argument((String)"newLives", (ArgumentType)IntegerArgumentType.integer((int)1, (int)UMPlayer.getMaxLives())).executes(commandContext -> SetCurrentLivesSC.modifySpeedRunnerLives((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), Modifier.ADD, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"newLives")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"newLives", (ArgumentType)IntegerArgumentType.integer((int)1, (int)UMPlayer.getMaxLives())).executes(commandContext -> SetCurrentLivesSC.modifySpeedRunnerLives((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), Modifier.SET, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"newLives")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"newLives", (ArgumentType)IntegerArgumentType.integer((int)1, (int)UMPlayer.getMaxLives())).executes(commandContext -> SetCurrentLivesSC.modifySpeedRunnerLives((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), Modifier.REMOVE, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"newLives"))))))))));
    }

    private static void logLifeChange(CommandSourceStack sourceStack, ServerPlayer serverPlayer, int lives) {
        sourceStack.sendSuccess(() -> Component.literal((String)("Set the speed runner lives of " + serverPlayer.getName().getString() + " to " + lives)), true);
    }

    private static void logFailLifeChange(CommandSourceStack sourceStack) {
        sourceStack.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Cannot modify speed runner lives when a game hasn't been started, or while a game is running. Please pause the game if you wish to modify the life counts of speed runners")));
    }

    private static int modifySpeedRunnerLives(CommandContext<CommandSourceStack> commandContext, Collection<ServerPlayer> players, Modifier modifier, int lives) {
        AtomicInteger i = new AtomicInteger();
        if (UMGame.getCurrentGameState() != UMGame.State.PAUSED) {
            SetCurrentLivesSC.logFailLifeChange((CommandSourceStack)commandContext.getSource());
            return 0;
        }
        for (ServerPlayer serverPlayer : players) {
            serverPlayer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                switch (modifier.ordinal()) {
                    case 0: {
                        umPlayer.setLives(umPlayer.getLives() + lives);
                        break;
                    }
                    case 1: {
                        umPlayer.setLives(lives);
                        break;
                    }
                    case 2: {
                        int newLives = Math.max(1, umPlayer.getLives() - lives);
                        umPlayer.setLives(newLives);
                    }
                }
                umPlayer.sendUpdateFromServerToSelf((Player)serverPlayer);
                SetCurrentLivesSC.logLifeChange((CommandSourceStack)commandContext.getSource(), serverPlayer, umPlayer.getLives());
                i.getAndIncrement();
            });
        }
        return i.get();
    }

    private static enum Modifier {
        ADD,
        SET,
        REMOVE;

    }
}

