/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.commands.sub.playerrole;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.game.RemainingPlayerCountS2CPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;

public final class SetCurrentPlayerRoleSC
extends UltimateManhuntCommands.SubCommand {
    public SetCurrentPlayerRoleSC(LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)argumentBuilder.then(Commands.literal((String)"roles").then(Commands.literal((String)"current").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"speed_runner").executes(commandContext -> SetCurrentPlayerRoleSC.modifyRoles((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), UMGame.PlayerRole.SPEED_RUNNER, false)))).then(((LiteralArgumentBuilder)Commands.literal((String)"hunter").executes(commandContext -> SetCurrentPlayerRoleSC.modifyRoles((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), UMGame.PlayerRole.HUNTER, false))).then(Commands.argument((String)"is_buffed_hunter", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> SetCurrentPlayerRoleSC.modifyRoles((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), UMGame.PlayerRole.HUNTER, BoolArgumentType.getBool((CommandContext)commandContext, (String)"is_buffed_hunter")))))).then(Commands.literal((String)"spectator").executes(commandContext -> SetCurrentPlayerRoleSC.modifyRoles((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), UMGame.PlayerRole.SPECTATOR, false))))))));
    }

    private static int modifyRoles(CommandSourceStack source, Collection<ServerPlayer> players, UMGame.PlayerRole playerRole, boolean isBuffedHunter) {
        AtomicInteger i = new AtomicInteger();
        if (UMGame.State.isGameRunning()) {
            source.sendFailure((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "A Manhunt game is currently in progress. Please pause or stop the game to change the roles of players!")));
            return 0;
        }
        players.forEach(serverPlayer -> serverPlayer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
            UMGame.PlayerRole oldRole = umPlayer.getRole();
            umPlayer.setRole(playerRole).setBuffedHunter(isBuffedHunter);
            if (oldRole == UMGame.PlayerRole.SPECTATOR && playerRole != UMGame.PlayerRole.SPECTATOR) {
                serverPlayer.setGameMode(GameType.DEFAULT_MODE);
            }
            source.sendSuccess(() -> Component.literal((String)("Set " + serverPlayer.getName().getString() + "'s role from " + oldRole.getAsName() + " to " + playerRole.getAsName())), true);
            if (playerRole == UMGame.PlayerRole.HUNTER) {
                if (isBuffedHunter) {
                    source.sendSuccess(() -> Component.literal((String)(serverPlayer.getName().getString() + " has been set to be a buffed hunter")), true);
                }
            } else {
                umPlayer.setBuffedHunter(false);
            }
            umPlayer.sendUpdateFromServerToSelf((Player)serverPlayer);
            i.getAndIncrement();
        }));
        UMPackets.sendToAllClients(new RemainingPlayerCountS2CPacket());
        return i.get();
    }
}

