/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.datagen;

import java.util.concurrent.CompletableFuture;
import net.laserdiamond.laserutils.datagen.LUDataGenerator;
import net.laserdiamond.laserutils.datagen.LULanguageProvider;
import net.laserdiamond.laserutils.util.registry.LanguageRegistry;
import net.laserdiamond.ultimatemanhunt.datagen.UMLanguageProvider;
import net.laserdiamond.ultimatemanhunt.datagen.UMSoundProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

public final class UMDataGenerator
extends LUDataGenerator<UMDataGenerator> {
    public UMDataGenerator(IEventBus eventBus) {
        super("ultimate_manhunt", eventBus);
    }

    protected void additionalGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookUpProvider = event.getLookupProvider();
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new UMSoundProvider(packOutput, existingFileHelper));
    }

    @NotNull
    protected LULanguageProvider<UMDataGenerator> languageProvider(PackOutput packOutput) {
        return new UMLanguageProvider(packOutput, this, (LanguageRegistry.LanguageType)LanguageRegistry.Language.EN_US);
    }
}

