/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Iterator;
import net.laserdiamond.ultimatemanhunt.UMGame;
import net.laserdiamond.ultimatemanhunt.UltimateManhunt;
import net.laserdiamond.ultimatemanhunt.api.event.RegisterManhuntSubCommandEvent;
import net.laserdiamond.ultimatemanhunt.api.event.SpeedRunnerLifeLossEvent;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.commands.UltimateManhuntCommands;
import net.laserdiamond.ultimatemanhunt.commands.sub.GameProfileSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.GracePeriodSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.SetGameStateSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.SetSpawnCommand;
import net.laserdiamond.ultimatemanhunt.commands.sub.gamerule.AllowWindTorchesSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.gamerule.BuffedHunterOnFinalDeathSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.gamerule.SetFriendlyFireSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.gamerule.SetHardcoreSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.lives.SetCurrentLivesSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.lives.SetMaxLivesSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.playerrole.SetCurrentPlayerRoleSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.playerrole.SetDeadPlayerRoleSC;
import net.laserdiamond.ultimatemanhunt.commands.sub.playerrole.SetNewPlayerRoleSC;
import net.laserdiamond.ultimatemanhunt.item.UMItems;
import net.laserdiamond.ultimatemanhunt.item.WindTorchItem;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.laserdiamond.ultimatemanhunt.network.packet.game.GameStateS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.HardcoreUpdateS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.RemainingPlayerCountS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.HunterGracePeriodDurationS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerDistanceFromHunterS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerGracePeriodDurationS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerMaxLifeChangeS2CPacket;
import net.laserdiamond.ultimatemanhunt.sound.UMSoundEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ultimate_manhunt")
public class ForgeEvents {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterManhuntSubCommandEvent(event));
        UltimateManhuntCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerSubCommands(RegisterManhuntSubCommandEvent event) {
        event.registerSubCommand(UltimateManhunt.fromUMPath("friendly_fire"), SetFriendlyFireSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("hardcore"), SetHardcoreSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("buffed_hunters_on_final_death"), BuffedHunterOnFinalDeathSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("allow_wind_torches"), AllowWindTorchesSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("dead_player_roles"), SetDeadPlayerRoleSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("new_player_roles"), SetNewPlayerRoleSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("current_player_roles"), SetCurrentPlayerRoleSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("max_lives"), SetMaxLivesSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("current_lives"), SetCurrentLivesSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("game_state"), SetGameStateSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("game_profile"), GameProfileSC::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("set_spawn"), SetSpawnCommand::new);
        event.registerSubCommand(UltimateManhunt.fromUMPath("grace_period"), GracePeriodSC::new);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (UMGame.State.isGameNotInProgress()) {
            return;
        }
        LivingEntity living = event.getEntity();
        if (living == null) {
            return;
        }
        if (living instanceof Player) {
            Player deadPlayer = (Player)living;
            Level level = deadPlayer.level();
            if (level.isClientSide) {
                return;
            }
            Entity sourceEntity = event.getSource().getEntity();
            deadPlayer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(deadUMPlayer -> {
                if (deadUMPlayer.isSpeedRunner()) {
                    if (UMGame.isHardcore()) {
                        MinecraftForge.EVENT_BUS.post((Event)new SpeedRunnerLifeLossEvent(deadPlayer, null));
                        return;
                    }
                    if (sourceEntity instanceof Player) {
                        Player killer = (Player)sourceEntity;
                        killer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                            if (umPlayer.isHunter()) {
                                MinecraftForge.EVENT_BUS.post((Event)new SpeedRunnerLifeLossEvent(deadPlayer, killer));
                            } else if (ForgeEvents.isNearHunter(deadPlayer)) {
                                MinecraftForge.EVENT_BUS.post((Event)new SpeedRunnerLifeLossEvent(deadPlayer, killer));
                            }
                        });
                        return;
                    }
                    if (ForgeEvents.isNearHunter(deadPlayer)) {
                        MinecraftForge.EVENT_BUS.post((Event)new SpeedRunnerLifeLossEvent(deadPlayer, null));
                    }
                } else if (deadUMPlayer.isHunter() && UMGame.areHuntersOnGracePeriod()) {
                    event.setCanceled(true);
                    deadPlayer.setHealth(deadPlayer.getMaxHealth());
                }
            });
        }
    }

    private static boolean isNearHunter(Player playerSpeedRunner) {
        Iterator<Player> iterator = UMPlayer.getHunters(false).iterator();
        if (iterator.hasNext()) {
            Player playerHunter = iterator.next();
            return UMGame.isNearHunter(playerSpeedRunner, playerHunter);
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity hurtEntity = event.getEntity();
        if (UMGame.State.isGameNotInProgress()) {
            if (hurtEntity.getType() == EntityType.ENDER_DRAGON) {
                event.setCanceled(true);
            }
        } else if (UMGame.State.isGameRunning() && hurtEntity instanceof Player) {
            Player player = (Player)hurtEntity;
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                if (umPlayer.isHunter() && UMGame.areHuntersOnGracePeriod()) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        if (living instanceof Player) {
            Player attackedPlayer = (Player)living;
            Entity attacker = event.getSource().getEntity();
            if (attacker == null) {
                return;
            }
            if (attacker.level().isClientSide) {
                return;
            }
            if (attacker instanceof Player) {
                Player attackingPlayer = (Player)attacker;
                attackingPlayer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(attackingUMPlayer -> attackedPlayer.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(attackedUMPlayer -> {
                    if (attackingUMPlayer.isHunter()) {
                        if (attackedUMPlayer.isHunter()) {
                            if (!UMGame.isFriendlyFire()) {
                                event.setCanceled(true);
                            }
                        } else if (attackedUMPlayer.isSpeedRunner() && attackedUMPlayer.isWasLastKilledByHunter() && UMPlayer.isSpeedRunnerOnGracePeriodServer(attackedPlayer)) {
                            long duration = (attackedUMPlayer.getGracePeriodTimeStamp() - UMGame.getCurrentGameTime()) / 20L;
                            attackingPlayer.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + attackedPlayer.getName().getString() + " is immune to hunters for " + String.valueOf(ChatFormatting.YELLOW) + duration + String.valueOf(ChatFormatting.BLUE) + " seconds")));
                            event.setCanceled(true);
                        }
                    } else if (attackingUMPlayer.isSpeedRunner() && attackedUMPlayer.isSpeedRunner() && !UMGame.isFriendlyFire()) {
                        event.setCanceled(true);
                    }
                }));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        UMPackets.sendToPlayer(new GameStateS2CPacket(UMGame.getCurrentGameState()), player);
        UMPackets.sendToPlayer(new HardcoreUpdateS2CPacket(UMGame.isHardcore()), player);
        UMPackets.sendToPlayer(new HunterGracePeriodDurationS2CPacket(UMGame.getHunterGracePeriod()), player);
        UMPackets.sendToPlayer(new SpeedRunnerGracePeriodDurationS2CPacket(UMGame.getSpeedRunnerGracePeriod()), player);
        UMPackets.sendToPlayer(new SpeedRunnerMaxLifeChangeS2CPacket(UMPlayer.getMaxLives()), player);
        if (!UMGame.isWindTorchEnabled()) {
            player.getInventory().clearOrCountMatchingItems(itemStack -> itemStack.getItem() instanceof WindTorchItem, -1, (Container)player.inventoryMenu.getCraftSlots());
        }
        if (UMGame.State.hasGameBeenStarted()) {
            if (!UMGame.containsLoggedPlayerUUID(player)) {
                player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                    player.sendSystemMessage((Component)Component.literal((String)("You joined a Manhunt game that is already in progress and have been declared as a " + UMGame.getNewPlayerRole().getAsName())));
                    player.getInventory().clearContent();
                    switch (UMGame.getNewPlayerRole()) {
                        case SPECTATOR: {
                            umPlayer.resetToSpectator(player, true);
                            break;
                        }
                        case SPEED_RUNNER: {
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.setGameMode(GameType.DEFAULT_MODE);
                            }
                            umPlayer.resetToSpeedRunner(player, true);
                            if (!UMGame.isWindTorchEnabled()) break;
                            player.getInventory().add(new ItemStack((ItemLike)UMItems.WIND_TORCH.get()));
                            break;
                        }
                        case HUNTER: {
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.setGameMode(GameType.DEFAULT_MODE);
                            }
                            umPlayer.resetToHunter(player, true);
                            break;
                        }
                        default: {
                            umPlayer.resetToSpectator(player, true);
                        }
                    }
                    umPlayer.sendUpdateFromServerToSelf(player);
                });
            }
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                if (umPlayer.isHunter()) {
                    if (umPlayer.isBuffedHunter() && UMGame.State.isGameRunning()) {
                        player.getAttributes().addTransientAttributeModifiers(UMPlayer.createHunterAttributes());
                    }
                    if (UMGame.getCurrentGameTime() < (long)UMGame.getHunterGracePeriod()) {
                        player.getAbilities().mayfly = true;
                        player.getAbilities().flying = true;
                        player.onUpdateAbilities();
                    }
                }
            });
            UMPackets.sendToAllClients(new RemainingPlayerCountS2CPacket());
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        UMPackets.sendToAllClients(new RemainingPlayerCountS2CPacket());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            UMSoundEvents.stopFlatlineSound(player);
            player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
                SpeedRunnerDistanceFromHunterS2CPacket.sendNotNearHunterAll();
                if (umPlayer.isWasLastKilledByHunter()) {
                    long timeStamp = UMGame.getCurrentGameTime() + (long)UMGame.getSpeedRunnerGracePeriod();
                    umPlayer.setGracePeriodTimeStamp(timeStamp);
                } else {
                    umPlayer.setGracePeriodTimeStamp(0L);
                }
                umPlayer.sendUpdateFromServerToSelf(player);
            });
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity targetEntity = event.getTarget();
        Player player = event.getEntity();
        if (targetEntity instanceof Player) {
            Player playerTarget = (Player)targetEntity;
            playerTarget.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> umPlayer.sendUpdateFromServer(playerTarget, player));
        }
    }

    @SubscribeEvent
    public static void onStopTracking(PlayerEvent.StopTracking event) {
        Player targetEntity = event.getEntity();
        Player player = event.getEntity();
        if (targetEntity instanceof Player) {
            Player playerTarget = targetEntity;
            playerTarget.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> umPlayer.sendUpdateFromServer(playerTarget, player));
        }
    }
}

