/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.network;

import java.util.function.Function;
import net.laserdiamond.laserutils.network.NetworkPacket;
import net.laserdiamond.laserutils.network.NetworkPackets;
import net.laserdiamond.ultimatemanhunt.UltimateManhunt;
import net.laserdiamond.ultimatemanhunt.network.packet.UMCapabilitySyncS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.GameStateS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.GameTimeS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.HardcoreUpdateS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.RemainingPlayerCountS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GameEndAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GamePausedAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GameResumedS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.GameStartAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.ChangeTrackingSpeedRunnerC2SPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.HunterGracePeriodDurationS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.HunterReleaseAnnounceS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.hunter.TrackingSpeedRunnerS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerDistanceFromHunterS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerGracePeriodDurationS2CPacket;
import net.laserdiamond.ultimatemanhunt.network.packet.speedrunner.SpeedRunnerMaxLifeChangeS2CPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.SimpleChannel;

@Mod.EventBusSubscriber(modid="ultimate_manhunt", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UMPackets {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    @SubscribeEvent
    public static void registerPackets(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> UMPackets.registerPackets());
    }

    private static int id() {
        return packetId++;
    }

    private static void registerPackets() {
        INSTANCE = ChannelBuilder.named((ResourceLocation)UltimateManhunt.fromUMPath("main")).serverAcceptedVersions((status, version) -> true).clientAcceptedVersions((status, version) -> true).networkProtocolVersion(1).simpleChannel();
        UMPackets.registerGamePackets();
        UMPackets.registerSpeedRunnerPackets();
        UMPackets.registerHunterPackets();
    }

    private static void registerSpeedRunnerPackets() {
        UMPackets.registerPacket(SpeedRunnerDistanceFromHunterS2CPacket.class, SpeedRunnerDistanceFromHunterS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(SpeedRunnerGracePeriodDurationS2CPacket.class, SpeedRunnerGracePeriodDurationS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(SpeedRunnerMaxLifeChangeS2CPacket.class, SpeedRunnerMaxLifeChangeS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void registerHunterPackets() {
        UMPackets.registerPacket(TrackingSpeedRunnerS2CPacket.class, TrackingSpeedRunnerS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(HunterReleaseAnnounceS2CPacket.class, HunterReleaseAnnounceS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(HunterGracePeriodDurationS2CPacket.class, HunterGracePeriodDurationS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(ChangeTrackingSpeedRunnerC2SPacket.class, ChangeTrackingSpeedRunnerC2SPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_SERVER);
    }

    private static void registerGamePackets() {
        UMPackets.registerPacket(UMCapabilitySyncS2CPacket.class, UMCapabilitySyncS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(GameStateS2CPacket.class, GameStateS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(GameTimeS2CPacket.class, GameTimeS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(GameStartAnnounceS2CPacket.class, GameStartAnnounceS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(GamePausedAnnounceS2CPacket.class, GamePausedAnnounceS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(GameResumedS2CPacket.class, GameResumedS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(GameEndAnnounceS2CPacket.class, GameEndAnnounceS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(HardcoreUpdateS2CPacket.class, HardcoreUpdateS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
        UMPackets.registerPacket(RemainingPlayerCountS2CPacket.class, RemainingPlayerCountS2CPacket::new, (NetworkDirection<RegistryFriendlyByteBuf>)NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <P extends NetworkPacket> void registerPacket(Class<P> packetClazz, Function<RegistryFriendlyByteBuf, P> decoder, NetworkDirection<RegistryFriendlyByteBuf> direction) {
        NetworkPackets.registerPacket((SimpleChannel)INSTANCE, (int)UMPackets.id(), packetClazz, decoder, direction);
    }

    public static <MSG> void sendToServer(MSG message) {
        NetworkPackets.sendToServer((SimpleChannel)INSTANCE, message);
    }

    public static <MSG> void sendToPlayer(MSG message, Player player) {
        NetworkPackets.sendToPlayer((SimpleChannel)INSTANCE, message, (ServerPlayer)((ServerPlayer)player));
    }

    public static <MSG> void sendToAllClients(MSG message) {
        NetworkPackets.sendToAllClients((SimpleChannel)INSTANCE, message);
    }

    public static <MSG> void sendToAllTrackingEntity(MSG message, Entity trackedEntity) {
        NetworkPackets.sendToAllTrackingEntity((SimpleChannel)INSTANCE, message, (Entity)trackedEntity);
    }

    public static <MSG> void sendToAllTrackingEntityAndSelf(MSG message, Entity trackedEntity) {
        NetworkPackets.sendToAllTrackingEntityAndSelf((SimpleChannel)INSTANCE, message, (Entity)trackedEntity);
    }

    static {
        packetId = 0;
    }
}

