/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.network.packet.game.announce;

import net.laserdiamond.ultimatemanhunt.api.event.UltimateManhuntGameStateEvent;
import net.laserdiamond.ultimatemanhunt.network.packet.game.announce.AnnounceS2CPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.event.network.CustomPayloadEvent;

public final class GameEndAnnounceS2CPacket
extends AnnounceS2CPacket {
    private final UltimateManhuntGameStateEvent.End.Reason reason;

    public GameEndAnnounceS2CPacket(UltimateManhuntGameStateEvent.End.Reason reason) {
        this.reason = reason;
    }

    public GameEndAnnounceS2CPacket(FriendlyByteBuf buf) {
        super(buf);
        this.reason = UltimateManhuntGameStateEvent.End.Reason.fromOrdinal(buf.readInt());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.reason.ordinal());
    }

    @Override
    public void packetWork(CustomPayloadEvent.Context context) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null) {
            player.playSound(SoundEvents.WITHER_DEATH);
        }
        super.packetWork(context);
    }

    @Override
    public Component title(Minecraft minecraft) {
        return switch (this.reason) {
            default -> throw new MatchException(null, null);
            case UltimateManhuntGameStateEvent.End.Reason.HUNTER_WIN -> Component.literal((String)(String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + "No more Speed Runners!"));
            case UltimateManhuntGameStateEvent.End.Reason.SPEED_RUNNERS_WIN -> Component.literal((String)(String.valueOf(ChatFormatting.AQUA) + String.valueOf(ChatFormatting.BOLD) + "Ender Dragon defeated!"));
            case UltimateManhuntGameStateEvent.End.Reason.COMMAND -> Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.BOLD) + "Game Ended"));
        };
    }

    @Override
    public Component subTitle(Minecraft minecraft) {
        return switch (this.reason) {
            default -> throw new MatchException(null, null);
            case UltimateManhuntGameStateEvent.End.Reason.HUNTER_WIN -> Component.literal((String)(String.valueOf(ChatFormatting.RED) + String.valueOf(ChatFormatting.BOLD) + "Hunters win!"));
            case UltimateManhuntGameStateEvent.End.Reason.SPEED_RUNNERS_WIN -> Component.literal((String)(String.valueOf(ChatFormatting.AQUA) + String.valueOf(ChatFormatting.BOLD) + "Speed Runners win!"));
            case UltimateManhuntGameStateEvent.End.Reason.COMMAND -> Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.BOLD) + "No one wins!"));
        };
    }
}

