/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.network.packet.hunter;

import java.util.List;
import net.laserdiamond.laserutils.network.NetworkPacket;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayer;
import net.laserdiamond.ultimatemanhunt.capability.UMPlayerCapability;
import net.laserdiamond.ultimatemanhunt.client.UMKeyBindings;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.jetbrains.annotations.NotNull;

public class ChangeTrackingSpeedRunnerC2SPacket
extends NetworkPacket {
    private final boolean isNext;

    public ChangeTrackingSpeedRunnerC2SPacket(@NotNull UMKeyBindings.TrackCycleDirection direction) {
        this.isNext = switch (direction) {
            default -> throw new MatchException(null, null);
            case UMKeyBindings.TrackCycleDirection.NEXT -> true;
            case UMKeyBindings.TrackCycleDirection.PREVIOUS -> false;
        };
    }

    public ChangeTrackingSpeedRunnerC2SPacket(FriendlyByteBuf buf) {
        this.isNext = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isNext);
    }

    public void packetWork(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        List<Player> availableSpeedRunners = UMPlayer.getAvailableSpeedRunners((Player)player);
        player.getCapability(UMPlayerCapability.UM_PLAYER).ifPresent(umPlayer -> {
            int trackingIndex = umPlayer.getTrackingIndex();
            if (availableSpeedRunners.isEmpty()) {
                return;
            }
            trackingIndex = this.isNext ? this.incrementTrackingIndex(trackingIndex, availableSpeedRunners.size()) : this.decrementTrackingIndex(trackingIndex, availableSpeedRunners.size());
            Player targetPlayer = (Player)availableSpeedRunners.get(trackingIndex);
            umPlayer.setPlayerToTrack(trackingIndex, targetPlayer).sendUpdateFromServerToSelf((Player)player);
        });
    }

    private int incrementTrackingIndex(int trackingIndex, int max) {
        if (++trackingIndex > max) {
            return 0;
        }
        return trackingIndex;
    }

    private int decrementTrackingIndex(int trackingIndex, int max) {
        if (--trackingIndex < 0) {
            return max;
        }
        return trackingIndex;
    }
}

