/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.network.packet.hunter;

import java.util.UUID;
import net.laserdiamond.laserutils.network.NetworkPacket;
import net.laserdiamond.ultimatemanhunt.client.hunter.ClientTrackedSpeedRunner;
import net.laserdiamond.ultimatemanhunt.network.UMPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class TrackingSpeedRunnerS2CPacket
extends NetworkPacket {
    private final boolean speedRunnersPresent;
    private final String playerName;
    private final UUID playerUUID;
    private final float distance;
    private final Vec3 position;

    public static void sendNonTracking(Player player) {
        UMPackets.sendToPlayer(new TrackingSpeedRunnerS2CPacket(false, player, 0.0f), player);
    }

    public TrackingSpeedRunnerS2CPacket(boolean speedRunnersPresent, Player player, float distance) {
        this.speedRunnersPresent = speedRunnersPresent;
        this.playerName = player.getName().getString();
        this.playerUUID = player.getUUID();
        this.distance = distance;
        this.position = player.getEyePosition();
    }

    public TrackingSpeedRunnerS2CPacket(FriendlyByteBuf buf) {
        this.speedRunnersPresent = buf.readBoolean();
        this.playerName = buf.readUtf();
        this.playerUUID = buf.readUUID();
        this.distance = buf.readFloat();
        this.position = buf.readVec3();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.speedRunnersPresent);
        buf.writeUtf(this.playerName);
        buf.writeUUID(this.playerUUID);
        buf.writeFloat(this.distance);
        buf.writeVec3(this.position);
    }

    public void packetWork(CustomPayloadEvent.Context context) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ClientTrackedSpeedRunner.setSpeedRunnersPresent(this.speedRunnersPresent);
        ClientTrackedSpeedRunner.setTrackedPlayerName(this.playerName);
        ClientTrackedSpeedRunner.setTrackedPlayerUUID(this.playerUUID);
        ClientTrackedSpeedRunner.setDistance(this.distance);
        ClientTrackedSpeedRunner.setPosition(this.position);
    }
}

