/*
 * Decompiled with CFR 0.152.
 */
package net.laserdiamond.ultimatemanhunt.util.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.laserdiamond.ultimatemanhunt.UltimateManhunt;

public abstract class JsonConfig {
    protected final String fileName;
    protected final File file;
    protected JsonObject jsonObject;

    public JsonConfig(String fileName) {
        this.fileName = fileName;
        this.file = new File(this.modFilePath() + fileName + ".json");
        this.createFile();
        try (FileReader fileReader = new FileReader(this.file);){
            this.jsonObject = this.createJsonNotNull((JsonObject)new Gson().fromJson((Reader)fileReader, JsonObject.class));
        }
        catch (IOException e) {
            UltimateManhunt.LOGGER.info("ERROR CREATING JSON OBJECT FOR FILE: " + fileName);
            e.printStackTrace();
        }
    }

    private String modFilePath() {
        return "ultimate_manhunt" + File.separator + this.folderName() + File.separator;
    }

    protected abstract String folderName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean createFile() {
        if (this.file.exists()) {
            return false;
        }
        this.file.getParentFile().mkdirs();
        try (FileWriter fileWriter = new FileWriter(this.file);){
            if (this.file.createNewFile()) {
                UltimateManhunt.LOGGER.info("Created File: " + this.fileName);
                fileWriter.write(this.jsonObjectPrettyPrint(this.jsonObject));
                boolean bl = true;
                return bl;
            }
            UltimateManhunt.LOGGER.info("Couldn't create file: " + this.fileName);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            UltimateManhunt.LOGGER.info("ERROR CREATING FILE: " + this.fileName + "!");
            e.printStackTrace();
            return false;
        }
    }

    public final boolean deleteFile() {
        return this.file.delete();
    }

    public boolean writeJsonToFile() {
        boolean bl;
        FileWriter fileWriter = new FileWriter(this.file);
        try {
            fileWriter.write(this.jsonObjectPrettyPrint(this.jsonObject));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                UltimateManhunt.LOGGER.info("ERROR WRITING JSON OBJECT: " + this.jsonObject.toString() + " TO FILE " + String.valueOf(this.file) + "!");
                e.printStackTrace();
                return false;
            }
        }
        fileWriter.close();
        return bl;
    }

    public boolean isJsonNotNull(String key) {
        return this.jsonObject.get(key) != null;
    }

    public boolean toJsonNotNull(JsonObject jsonObject, String key, String value) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, value);
            return true;
        }
        return false;
    }

    public boolean toJsonNotNull(JsonObject jsonObject, String key, JsonElement jsonElement) {
        if (jsonObject.get(key) == null) {
            jsonObject.add(key, jsonElement);
            return true;
        }
        return false;
    }

    public boolean toJsonNotNull(JsonObject jsonObject, String key, Number value) {
        if (jsonObject.get(key) == null) {
            jsonObject.addProperty(key, value);
            return true;
        }
        return false;
    }

    public JsonObject createJsonNotNull(JsonObject jsonObject) {
        if (jsonObject == null) {
            jsonObject = new JsonObject();
        }
        return jsonObject;
    }

    protected final String jsonObjectPrettyPrint(JsonObject jsonObject) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement prettyJson = JsonParser.parseString((String)jsonObject.toString());
        return gson.toJson(prettyJson);
    }
}

