/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.alwayseat;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.FoodProperties;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class AlwaysEat
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
    }

    @EventHandler
    public void on(ItemSpawnEvent event) {
        ItemStack itemStack = event.getEntity().getItemStack();
        this.applyAlwaysEatAttribute(itemStack);
    }

    @EventHandler
    public void on(PrepareItemCraftEvent event) {
        this.applyAlwaysEatAttribute(event.getInventory().getResult());
    }

    @EventHandler
    public void on(InventoryClickEvent event) {
        this.applyAlwaysEatAttribute(event.getCurrentItem());
        this.applyAlwaysEatAttribute(event.getCursor());
    }

    @EventHandler
    public void on(PlayerItemHeldEvent event) {
        this.applyAlwaysEatAttribute(event.getPlayer().getInventory().getItem(event.getNewSlot()));
    }

    @EventHandler
    public void on(InventoryOpenEvent event) {
        for (ItemStack itemStack : event.getInventory().getContents()) {
            if (itemStack == null) continue;
            this.applyAlwaysEatAttribute(itemStack);
        }
    }

    private void applyAlwaysEatAttribute(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        FoodProperties foodComponent = (FoodProperties)itemStack.getData(DataComponentTypes.FOOD);
        if (foodComponent != null) {
            itemStack.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)FoodProperties.food().canAlwaysEat(true).nutrition(foodComponent.nutrition()).saturation(foodComponent.saturation()).build()));
        }
    }
}

