/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.config.adapters.other;

import com.artillexstudios.axgraves.libs.axapi.config.adapters.TypeAdapter;
import com.artillexstudios.axgraves.libs.axapi.config.adapters.TypeAdapterHolder;
import com.artillexstudios.axgraves.libs.axapi.utils.UncheckedUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public final class EnumAdapter
implements TypeAdapter<Enum<?>, String> {
    @Override
    public Enum<?> deserialize(TypeAdapterHolder holder, Object input, Type type) {
        if (input instanceof Enum) {
            Enum e = (Enum)input;
            return e;
        }
        if (input instanceof String) {
            Class cl;
            String st = (String)input;
            if (type instanceof Class && Enum.class.isAssignableFrom(cl = (Class)type)) {
                Class clazz = (Class)UncheckedUtils.unsafeCast(cl);
                for (Enum enumConstant : (Enum[])clazz.getEnumConstants()) {
                    if (!enumConstant.name().equalsIgnoreCase(st)) continue;
                    return enumConstant;
                }
                throw new IllegalArgumentException("No enum constant with the name " + st + " was found! Possible constants: " + Arrays.toString(Arrays.stream((Enum[])clazz.getEnumConstants()).map(Enum::name).toArray()));
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String serialize(TypeAdapterHolder holder, Enum<?> value, Type type) {
        return value.name();
    }

    @Override
    public List<String> values(Type type) {
        if (!(type instanceof Class)) {
            return List.of();
        }
        Class clazz = (Class)type;
        return Arrays.stream(clazz.getDeclaringClass().getEnumConstants()).map(en -> ((Enum)en).name()).toList();
    }
}

