/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.gui.configuration;

import com.artillexstudios.axgraves.libs.axapi.config.adapters.ConfigurationGetter;
import com.artillexstudios.axgraves.libs.axapi.config.adapters.MapConfigurationGetter;
import com.artillexstudios.axgraves.libs.axapi.context.HashMapContext;
import com.artillexstudios.axgraves.libs.axapi.gui.configuration.ConfigurationBackedGuiBuilder;
import com.artillexstudios.axgraves.libs.axapi.gui.configuration.actions.Action;
import com.artillexstudios.axgraves.libs.axapi.gui.configuration.actions.Actions;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.Gui;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.GuiItem;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.GuiKeys;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.implementation.PaginatedGui;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.provider.implementation.CachingGuiItemProvider;
import com.artillexstudios.axgraves.libs.axapi.placeholders.PlaceholderParameters;
import com.artillexstudios.axgraves.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axgraves.libs.axapi.utils.UncheckedUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axgraves.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public class ConfigurationBackedGui<T extends Gui> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("-");
    private final ConfigurationBackedGuiBuilder builder;

    public ConfigurationBackedGui(ConfigurationBackedGuiBuilder builder) {
        this.builder = builder;
    }

    private void setItems(T gui, HashMapContext globalContext) {
        List<MapConfigurationGetter> items = this.builder.configuration().getList("items", MapConfigurationGetter::new);
        if (items == null) {
            items = new ArrayList<MapConfigurationGetter>();
            if (this.builder.supportsLegacy()) {
                for (Object object : this.builder.configuration().keys()) {
                    String keyString = object.toString();
                    if (this.builder.overrideItems().containsKey(keyString) || this.builder.ignoredKeys().contains(keyString)) continue;
                    items.add(this.builder.configuration().getConfiguration(keyString));
                }
            }
        }
        for (MapConfigurationGetter mapConfigurationGetter : items) {
            Object slotConfig = mapConfigurationGetter.getObject("slots");
            if (slotConfig == null) {
                LogUtils.warn("Failed to add item: {} to the gui, because it didn't have any slots set up!", mapConfigurationGetter);
                continue;
            }
            IntList slots = this.slots(slotConfig);
            List<Action<?>> actions = Actions.INSTANCE.parseAll(mapConfigurationGetter.getList("actions"));
            CachingGuiItemProvider provider = new CachingGuiItemProvider(new GuiItem(ctx -> ItemBuilder.create((ConfigurationGetter)item, new PlaceholderParameters((HashMapContext)ctx)).wrapped(), (context, event) -> {
                context.merge(globalContext);
                for (Action action : actions) {
                    action.run((Player)event.getWhoClicked(), (HashMapContext)context);
                }
            }));
            slots.intIterator().forEachRemaining(integer -> gui.setItem(integer, provider));
        }
        for (Map.Entry entry : this.builder.overrideItems().entrySet()) {
            MapConfigurationGetter item = this.builder.configuration().getConfiguration((String)entry.getKey());
            if (item == null) {
                if (((Boolean)FeatureFlags.STRICT_ITEM_OVERRIDE_HANDLING.get()).booleanValue()) {
                    LogUtils.error("Could not find item within section {} in file! Did you remove it? This is not allowed! Please regenerate the file!", entry.getKey());
                    throw new IllegalStateException();
                }
                return;
            }
            Object slotConfig = item.getObject("slots");
            if (slotConfig == null) {
                LogUtils.warn("Failed to add item: {} to the gui, because it didn't have any slots set up!", item);
                continue;
            }
            IntList slots = this.slots(slotConfig);
            List<Action<?>> actions = Actions.INSTANCE.parseAll(item.getList("actions"));
            CachingGuiItemProvider provider = new CachingGuiItemProvider(new GuiItem(ctx -> ItemBuilder.create((ConfigurationGetter)item, new PlaceholderParameters((HashMapContext)ctx)).wrapped(), (context, event) -> {
                context.merge(globalContext);
                for (Action action : actions) {
                    action.run((Player)event.getWhoClicked(), (HashMapContext)context);
                }
                ((Consumer)entry.getValue()).accept(event);
            }));
            slots.intIterator().forEachRemaining(integer -> gui.setItem(integer, provider));
        }
    }

    public IntList slots(Object slots) {
        Object object = slots;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                Number number = (Number)object2;
                yield IntList.of((int)number.intValue());
            }
            case 1 -> {
                String str = (String)object2;
                yield this.parseSlot(str);
            }
            case 2 -> {
                List list = (List)object2;
                IntArrayList newList = new IntArrayList(list.size());
                for (Object o : list) {
                    newList.addAll(this.slots(o));
                }
                yield newList;
            }
            default -> IntList.of();
        };
    }

    public ConfigurationBackedGuiBuilder builder() {
        return this.builder;
    }

    private IntList parseSlot(String str) {
        if (str.contains("-")) {
            IntArrayList list = new IntArrayList();
            String[] arr = SPLIT_PATTERN.split(str);
            int from = Integer.parseInt(arr[0]);
            int to = Integer.parseInt(arr[1]);
            int min = Math.min(from, to);
            int max = Math.max(from, to);
            for (int i = min; i <= max; ++i) {
                list.add(i);
            }
            return list;
        }
        return IntList.of((int)Integer.parseInt(str));
    }

    public synchronized T create(Player player, HashMapContext globalContext) throws IllegalStateException {
        this.builder.guiBuilder().context(globalContext);
        Gui gui = (Gui)UncheckedUtils.unsafeCast(this.builder.guiBuilder().build(player));
        if (gui instanceof PaginatedGui) {
            PaginatedGui paginatedGui = (PaginatedGui)gui;
            if (this.builder.objectProvider() != null) {
                paginatedGui.setItemsProvider(this.builder.objectProvider().apply(globalContext));
            }
        }
        gui.disableAllInteractions();
        try {
            this.setItems(gui, globalContext);
        }
        catch (IllegalStateException exception) {
            return null;
        }
        if (this.builder.inventoryCloseListener() != null) {
            gui.onClose(this.builder.inventoryCloseListener());
        }
        if (this.builder.inventoryOpenListener() != null) {
            gui.onOpen(this.builder.inventoryOpenListener());
        }
        if (this.builder.playerInventoryClickListener() != null) {
            gui.onPlayerInventoryClick(this.builder.playerInventoryClickListener());
        }
        if (this.builder.refreshInterval() != null) {
            gui.setRefreshInterval(this.builder.refreshInterval());
        }
        return (T)gui;
    }

    public T create(Player player) throws IllegalStateException {
        return this.create(player, HashMapContext.create().with(GuiKeys.PLAYER, player));
    }
}

