/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.utils;

import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Cache;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axgraves.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axgraves.libs.axapi.utils.Pair;
import com.artillexstudios.axgraves.libs.axapi.utils.featureflags.FeatureFlags;
import it.unimi.dsi.fastutil.chars.CharImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    private static final TagResolver EMPTY_RESOLVER = TagResolver.empty();
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([0-9a-fA-F]{6})");
    private static final Pattern UNUSUAL_LEGACY_HEX_PATTERN = Pattern.compile("&x&([a-fA-F0-9])&([a-fA-F0-9])&([a-fA-F0-9])&([a-fA-F0-9])&([a-fA-F0-9])&([a-fA-F0-9])");
    private static final ObjectImmutableList<Pair<String, String>> COLOR_FORMATS = ObjectImmutableList.of((Object[])new Pair[]{Pair.of("&0", "<black>"), Pair.of("&1", "<dark_blue>"), Pair.of("&2", "<dark_green>"), Pair.of("&3", "<dark_aqua>"), Pair.of("&4", "<dark_red>"), Pair.of("&5", "<dark_purple>"), Pair.of("&6", "<gold>"), Pair.of("&7", "<gray>"), Pair.of("&8", "<dark_gray>"), Pair.of("&9", "<blue>"), Pair.of("&a", "<green>"), Pair.of("&b", "<aqua>"), Pair.of("&c", "<red>"), Pair.of("&d", "<light_purple>"), Pair.of("&e", "<yellow>"), Pair.of("&f", "<white>"), Pair.of("&r", "<reset>"), Pair.of("\n", "<br>")});
    private static final CharImmutableList COLOR_CHARS = CharImmutableList.of((char[])new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', '#'});
    private static final Cache<String, String> COLOR_CACHE = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).maximumSize((long)((Integer)FeatureFlags.COLOR_CACHE_SIZE.get()).intValue()).build();
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().tags(StandardTags.defaults()).build();
    public static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().character('\u00a7').hexColors().build();

    public static Component format(@NotNull String input, @NotNull Map<String, String> replacements) {
        return StringUtils.format(input, ItemBuilder.mapResolvers(replacements));
    }

    public static Component format(@NotNull String input, TagResolver ... resolvers) {
        if (((Boolean)FeatureFlags.USE_LEGACY_HEX_FORMATTER.get()).booleanValue()) {
            input = ItemBuilder.toTagResolver(input, resolvers);
            return LEGACY_COMPONENT_SERIALIZER.deserialize(StringUtils.formatToString(input, resolvers)).applyFallbackStyle(new StyleBuilderApplicable[]{TextDecoration.ITALIC.withState(false)});
        }
        String formatted = (String)COLOR_CACHE.get((Object)input, str -> {
            String toFormat = str.replace('\u00a7', '&');
            toFormat = StringUtils.replaceLegacyFormat(toFormat, "&l", "<b>", "</b>");
            toFormat = StringUtils.replaceLegacyFormat(toFormat, "&m", "<st>", "</st>");
            toFormat = StringUtils.replaceLegacyFormat(toFormat, "&n", "<u>", "</u>");
            toFormat = StringUtils.replaceLegacyFormat(toFormat, "&o", "<i>", "</i>");
            toFormat = StringUtils.replaceLegacyFormat(toFormat, "&k", "<obf>", "</obf>");
            toFormat = HEX_PATTERN.matcher(toFormat).replaceAll(fo -> "<#" + fo.group(1) + ">");
            toFormat = UNUSUAL_LEGACY_HEX_PATTERN.matcher(toFormat).replaceAll(fo -> "<#" + fo.group(0) + fo.group(1) + fo.group(2) + fo.group(3) + fo.group(4) + fo.group(5) + ">");
            toFormat = UNUSUAL_LEGACY_HEX_PATTERN.matcher(toFormat).replaceAll(fo -> "");
            for (Pair placeholder : COLOR_FORMATS) {
                toFormat = toFormat.replace((CharSequence)placeholder.first(), (CharSequence)placeholder.second());
            }
            toFormat = ItemBuilder.toTagResolver(toFormat, resolvers);
            return toFormat;
        });
        if (formatted == null) {
            return Component.empty();
        }
        return MINI_MESSAGE.deserialize(formatted, resolvers.length == 0 ? EMPTY_RESOLVER : TagResolver.resolver(resolvers)).applyFallbackStyle(new StyleBuilderApplicable[]{TextDecoration.ITALIC.withState(false)});
    }

    public static String formatToString(@NotNull String string, TagResolver ... resolvers) {
        if (((Boolean)FeatureFlags.USE_LEGACY_HEX_FORMATTER.get()).booleanValue()) {
            String changed = string.replace("\u00a7", "&");
            changed = ItemBuilder.toTagResolver(changed, resolvers);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.legacyHexFormat(LEGACY_COMPONENT_SERIALIZER.serialize(MINI_MESSAGE.deserialize(changed, resolvers))));
        }
        return LEGACY_COMPONENT_SERIALIZER.serialize(StringUtils.format(string, resolvers));
    }

    public static String formatToString(@NotNull String string, @NotNull Map<String, String> replacements) {
        return StringUtils.formatToString(string, ItemBuilder.mapResolvers(replacements));
    }

    @NotNull
    public static List<Component> formatList(@NotNull List<String> list, TagResolver ... resolvers) {
        ArrayList<Component> newList = new ArrayList<Component>(list.size());
        for (String line : list) {
            newList.add(StringUtils.format(line, resolvers));
        }
        return newList;
    }

    @NotNull
    public static List<Component> formatList(@NotNull List<String> list, Map<String, String> replacements) {
        return StringUtils.formatList(list, ItemBuilder.mapResolvers(replacements));
    }

    @NotNull
    public static List<String> formatListToString(@NotNull List<String> list, TagResolver ... resolvers) {
        ArrayList<String> newList = new ArrayList<String>(list.size());
        for (String line : list) {
            newList.add(StringUtils.formatToString(line, resolvers));
        }
        return newList;
    }

    @NotNull
    public static List<String> formatListToString(@NotNull List<String> list, Map<String, String> replacements) {
        return StringUtils.formatListToString(list, ItemBuilder.mapResolvers(replacements));
    }

    public static String formatNumber(String pattern, double number) {
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(number);
    }

    @NotNull
    public static String formatTime(long time) {
        Duration remainingTime = Duration.ofMillis(time);
        long total = remainingTime.getSeconds();
        long hours = total / 3600L;
        long minutes = total % 3600L / 60L;
        long seconds = total % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private static String replaceLegacyFormat(String toFormat, String search, String start, String close) {
        int index;
        block0: while ((index = toFormat.indexOf(search)) != -1) {
            toFormat = org.apache.commons.lang3.StringUtils.replaceOnce((String)toFormat, (String)search, (String)start);
            for (int i = index; i < toFormat.length(); ++i) {
                if (toFormat.charAt(i) != '&' || i + 1 >= toFormat.length() || !COLOR_CHARS.contains(toFormat.charAt(i + 1))) continue;
                StringBuilder stringBuilder = new StringBuilder(toFormat);
                stringBuilder.insert(i, close);
                toFormat = stringBuilder.toString();
                continue block0;
            }
        }
        return toFormat;
    }

    public static String legacyHexFormat(String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder builder = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(builder, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return matcher.appendTail(builder).toString();
    }
}

