/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axgraves.libs.lamp.bukkit.brigadier.BukkitVersion;
import com.mojang.brigadier.arguments.ArgumentType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MinecraftArgumentType {
    ENTITY("ArgumentEntity", Boolean.TYPE, Boolean.TYPE),
    GAME_PROFILE("ArgumentProfile", new Class[0]),
    COLOR("ArgumentChatFormat", new Class[0]),
    COMPONENT("ArgumentChatComponent", new Class[0]),
    MESSAGE("ArgumentChat", new Class[0]),
    NBT("ArgumentNBTTag", new Class[0]),
    NBT_TAG("ArgumentNBTBase", new Class[0]),
    NBT_PATH("ArgumentNBTKey", new Class[0]),
    SCOREBOARD_OBJECTIVE("ArgumentScoreboardObjective", new Class[0]),
    OBJECTIVE_CRITERIA("ArgumentScoreboardCriteria", new Class[0]),
    SCOREBOARD_SLOT("ArgumentScoreboardSlot", new Class[0]),
    SCORE_HOLDER("ArgumentScoreholder", new Class[0]),
    TEAM("ArgumentScoreboardTeam", new Class[0]),
    OPERATION("ArgumentMathOperation", new Class[0]),
    PARTICLE("ArgumentParticle", new Class[0]),
    ANGLE("ArgumentAngle", new Class[0]),
    ITEM_SLOT("ArgumentInventorySlot", new Class[0]),
    RESOURCE_LOCATION("ArgumentMinecraftKeyRegistered", new Class[0]),
    POTION_EFFECT("ArgumentMobEffect", new Class[0]),
    ENCHANTMENT("ArgumentEnchantment", new Class[0]),
    ENTITY_SUMMON("ArgumentEntitySummon", new Class[0]),
    DIMENSION("ArgumentDimension", new Class[0]),
    TIME("ArgumentTime", new Class[0]),
    UUID("ArgumentUUID", new Class[0]),
    BLOCK_POS("coordinates.ArgumentPosition", new Class[0]),
    COLUMN_POS("coordinates.ArgumentVec2I", new Class[0]),
    VECTOR_3("coordinates.ArgumentVec3", new Class[0]),
    VECTOR_2("coordinates.ArgumentVec2", new Class[0]),
    ROTATION("coordinates.ArgumentRotation", new Class[0]),
    SWIZZLE("coordinates.ArgumentRotationAxis", new Class[0]),
    BLOCK_STATE("blocks.ArgumentTile", new Class[0]),
    BLOCK_PREDICATE("blocks.ArgumentBlockPredicate", new Class[0]),
    ITEM_STACK("item.ArgumentItemStack", new Class[0]),
    ITEM_PREDICATE("item.ArgumentItemPredicate", new Class[0]),
    FUNCTION("item.ArgumentTag", new Class[0]),
    ENTITY_ANCHOR("ArgumentAnchor", new Class[0]),
    INT_RANGE("ArgumentCriterionValue$b", new Class[0]),
    FLOAT_RANGE("ArgumentCriterionValue$a", new Class[0]),
    TEMPLATE_MIRROR("TemplateMirrorArgument", new Class[0]),
    TEMPLATE_ROTATION("TemplateRotationArgument", new Class[0]);

    @Nullable
    private ArgumentType<?> argumentType;
    @Nullable
    private Constructor<? extends ArgumentType> argumentConstructor;
    private final Class<?>[] parameters;

    private MinecraftArgumentType(String name, Class<?> ... parameters) {
        Class<?> argumentClass = MinecraftArgumentType.resolveArgumentClass(name);
        this.parameters = parameters;
        if (argumentClass == null) {
            this.argumentType = null;
            this.argumentConstructor = null;
            return;
        }
        try {
            this.argumentConstructor = argumentClass.asSubclass(ArgumentType.class).getDeclaredConstructor(parameters);
            if (!this.argumentConstructor.isAccessible()) {
                this.argumentConstructor.setAccessible(true);
            }
            this.argumentType = parameters.length == 0 ? this.argumentConstructor.newInstance(new Object[0]) : null;
        }
        catch (Throwable e) {
            this.argumentType = null;
            this.argumentConstructor = null;
        }
    }

    public boolean isSupported() {
        return this.argumentConstructor != null;
    }

    public boolean requiresParameters() {
        return this.parameters.length != 0;
    }

    @NotNull
    public <T> ArgumentType<T> get() {
        if (this.argumentConstructor == null) {
            throw new IllegalArgumentException("Argument type '" + this.name().toLowerCase() + "' is not available on this version.");
        }
        if (this.argumentType != null) {
            return this.argumentType;
        }
        throw new IllegalArgumentException("This argument type requires " + this.parameters.length + " parameter(s) of type(s) " + Arrays.stream(this.parameters).map(Class::getName).collect(Collectors.joining(", ")) + ". Use #create() instead.");
    }

    @NotNull
    public <T> ArgumentType<T> create(Object ... arguments) {
        if (this.argumentConstructor == null) {
            throw new IllegalArgumentException("Argument type '" + this.name().toLowerCase() + "' is not available on this version.");
        }
        if (this.argumentType != null && arguments.length == 0) {
            return this.argumentType;
        }
        return this.argumentConstructor.newInstance(arguments);
    }

    @NotNull
    public <T> Optional<ArgumentType<T>> getIfPresent() {
        if (this.argumentConstructor == null) {
            return Optional.empty();
        }
        if (this.argumentType != null) {
            return Optional.of(this.argumentType);
        }
        throw new IllegalArgumentException("This argument type requires " + this.parameters.length + " parameter(s) of type(s) " + Arrays.stream(this.parameters).map(Class::getName).collect(Collectors.joining(", ")) + ". Use #create() instead.");
    }

    @NotNull
    public <T> Optional<ArgumentType<T>> createIfPresent(Object ... arguments) {
        if (this.argumentConstructor == null) {
            return Optional.empty();
        }
        if (this.argumentType != null && arguments.length == 0) {
            return Optional.of(this.argumentType);
        }
        return Optional.of(this.argumentConstructor.newInstance(arguments));
    }

    @Nullable
    private static Class<?> resolveArgumentClass(String name) {
        try {
            if (BukkitVersion.supports(1, 16)) {
                try {
                    return BukkitVersion.findNmsClass("commands.arguments." + name);
                }
                catch (Throwable ignored) {
                    return Class.forName("net.minecraft.commands.arguments." + name);
                }
            }
            String stripped = name.lastIndexOf(46) != -1 ? name.substring(name.lastIndexOf(46) + 1) : name;
            return BukkitVersion.findNmsClass(stripped);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void ensureSetup() {
    }
}

