/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards;

import com.playtimerewards.commands.PlaytimeRewardsCommand;
import com.playtimerewards.commands.TabCompleter;
import com.playtimerewards.listeners.InventoryClickListener;
import com.playtimerewards.listeners.PlayerJoinListener;
import com.playtimerewards.listeners.PlayerQuitListener;
import com.playtimerewards.managers.ConfigManager;
import com.playtimerewards.managers.DataManager;
import com.playtimerewards.managers.LanguageManager;
import com.playtimerewards.managers.RewardManager;
import com.playtimerewards.utils.PlaytimeTracker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlaytimeRewards
extends JavaPlugin {
    private static PlaytimeRewards instance;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private DataManager dataManager;
    private RewardManager rewardManager;
    private PlaytimeTracker playtimeTracker;

    public void onEnable() {
        instance = this;
        this.initializeManagers();
        this.registerCommands();
        this.registerListeners();
        this.startPlaytimeTracking();
        this.getLogger().info("PlaytimeRewards v" + this.getDescription().getVersion() + " has been enabled!");
        this.getLogger().info("Loaded " + this.rewardManager.getRewardCount() + " reward milestones");
        this.getLogger().info("Active language: " + this.languageManager.getDefaultLanguage());
    }

    public void onDisable() {
        if (this.playtimeTracker != null) {
            this.playtimeTracker.stopTracking();
        }
        if (this.dataManager != null) {
            this.dataManager.saveAllDataSync();
        }
        this.getLogger().info("PlaytimeRewards has been disabled. All data has been saved.");
    }

    private void initializeManagers() {
        try {
            this.configManager = new ConfigManager(this);
            this.languageManager = new LanguageManager(this);
            this.dataManager = new DataManager(this);
            this.rewardManager = new RewardManager(this);
            this.getLogger().info("All managers initialized successfully");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize managers: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void registerCommands() {
        PlaytimeRewardsCommand commandExecutor = new PlaytimeRewardsCommand(this);
        TabCompleter tabCompleter = new TabCompleter(this);
        this.getCommand("playtimerewards").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("playtimerewards").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getLogger().info("Commands registered successfully");
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getLogger().info("Event listeners registered successfully");
    }

    private void startPlaytimeTracking() {
        this.playtimeTracker = new PlaytimeTracker(this);
        this.playtimeTracker.startTracking();
        this.getLogger().info("Playtime tracking started successfully");
    }

    public boolean reloadPlugin() {
        try {
            if (this.playtimeTracker != null) {
                this.playtimeTracker.stopTracking();
            }
            if (this.dataManager != null) {
                this.dataManager.saveAllData();
            }
            this.configManager.reloadConfig();
            this.languageManager.reloadLanguages();
            this.dataManager.reloadData();
            this.rewardManager.reloadRewards();
            if (this.playtimeTracker != null) {
                this.playtimeTracker.startTracking();
            }
            this.getLogger().info("Plugin reloaded successfully");
            return true;
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to reload plugin: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static PlaytimeRewards getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public PlaytimeTracker getPlaytimeTracker() {
        return this.playtimeTracker;
    }
}

