/*
 * Decompiled with CFR 0.152.
 */
package com.playtimerewards.commands;

import com.playtimerewards.PlaytimeRewards;
import com.playtimerewards.gui.RewardsGUI;
import com.playtimerewards.managers.DataManager;
import com.playtimerewards.managers.LanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlaytimeRewardsCommand
implements CommandExecutor {
    private final PlaytimeRewards plugin;
    private final LanguageManager languageManager;
    private final DataManager dataManager;

    public PlaytimeRewardsCommand(PlaytimeRewards plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.dataManager = plugin.getDataManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return this.handleGUICommand(sender);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReloadCommand(sender);
            }
            case "time": {
                return this.handleTimeCommand(sender, args);
            }
            case "add": {
                return this.handleAddCommand(sender, args);
            }
        }
        sender.sendMessage(this.languageManager.getMessage(sender, "commands.usage", "Usage: /playtimerewards [reload|time <player>|add <amount>]"));
        return true;
    }

    private boolean handleGUICommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.player_only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("playtimerewards.use")) {
            player.sendMessage(this.languageManager.getMessage((CommandSender)player, "commands.no_permission"));
            return true;
        }
        RewardsGUI gui = new RewardsGUI(this.plugin, player);
        gui.openGUI();
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("playtimerewards.reload")) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.no_permission"));
            return true;
        }
        boolean success = this.plugin.reloadPlugin();
        if (success) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.reload_success"));
        } else {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.reload_error"));
        }
        return true;
    }

    private boolean handleTimeCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.showPlayerTime(sender, player);
            } else {
                sender.sendMessage("Usage: /playtimerewards time <player>");
            }
            return true;
        }
        String targetPlayerName = args[1];
        if (!sender.getName().equals(targetPlayerName) && !sender.hasPermission("playtimerewards.time.others")) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.no_permission"));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer != null) {
            this.showPlayerTime(sender, targetPlayer);
        } else {
            this.showOfflinePlayerTime(sender, targetPlayerName);
        }
        return true;
    }

    private void showPlayerTime(CommandSender sender, Player player) {
        int playtimeMinutes = this.dataManager.getPlayerPlaytime(player.getUniqueId());
        int hours = playtimeMinutes / 60;
        int minutes = playtimeMinutes % 60;
        String timeMessage = sender.getName().equals(player.getName()) ? this.languageManager.getMessage(sender, "commands.playtime_self").replace("%hours%", String.valueOf(hours)).replace("%minutes%", String.valueOf(minutes)) : this.languageManager.getMessage(sender, "commands.playtime_other").replace("%player%", player.getName()).replace("%hours%", String.valueOf(hours)).replace("%minutes%", String.valueOf(minutes));
        sender.sendMessage(timeMessage);
    }

    private void showOfflinePlayerTime(CommandSender sender, String playerName) {
        String errorMessage = this.languageManager.getMessage(sender, "commands.invalid_player").replace("%player%", playerName);
        sender.sendMessage(errorMessage);
    }

    private boolean handleAddCommand(CommandSender sender, String[] args) {
        Player targetPlayer;
        int amount;
        if (!sender.hasPermission("playtimerewards.add")) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.no_permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.add_usage", "Usage: /playtimerewards add <amount> [player]"));
            return true;
        }
        try {
            amount = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.invalid_amount", "Invalid amount: " + args[1]));
            return true;
        }
        if (amount <= 0) {
            sender.sendMessage(this.languageManager.getMessage(sender, "commands.invalid_amount", "Amount must be positive: " + amount));
            return true;
        }
        if (args.length >= 3) {
            targetPlayer = Bukkit.getPlayer((String)args[2]);
            if (targetPlayer == null) {
                sender.sendMessage(this.languageManager.getMessage(sender, "commands.invalid_player").replace("%player%", args[2]));
                return true;
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.languageManager.getMessage(sender, "commands.player_only"));
                return true;
            }
            targetPlayer = (Player)sender;
        }
        int oldPlaytime = this.dataManager.getPlayerPlaytime(targetPlayer.getUniqueId());
        this.dataManager.addPlaytime(targetPlayer.getUniqueId(), amount);
        int newPlaytime = this.dataManager.getPlayerPlaytime(targetPlayer.getUniqueId());
        String successMessage = this.languageManager.getMessage(sender, "commands.add_success", "Added %amount% minutes to %player%. Total: %total% minutes").replace("%amount%", String.valueOf(amount)).replace("%player%", targetPlayer.getName()).replace("%total%", String.valueOf(newPlaytime));
        sender.sendMessage(successMessage);
        if (!sender.equals((Object)targetPlayer)) {
            String notifyMessage = this.languageManager.getMessage((CommandSender)targetPlayer, "commands.add_received", "You received %amount% minutes of playtime! Total: %total% minutes").replace("%amount%", String.valueOf(amount)).replace("%total%", String.valueOf(newPlaytime));
            targetPlayer.sendMessage(notifyMessage);
        }
        return true;
    }
}

